/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class DoubleSerializer extends JsonSerializer<Double> {

  @Override
  public void serialize(Double number, JsonGenerator jsonGenerator,
      SerializerProvider serializerProvider) throws IOException {
    ApiJsonSerializer.serializeNumberWithDecimals(number, jsonGenerator);
  }
}
