/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import static com.geotab.model.serialization.ApiCustomDeserializerModifier.defaultDeserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.entity.user.User;
import java.io.IOException;

public class DriverFromIdDeserializer extends JsonDeserializer<Driver> {

  @Override
  public Driver deserialize(JsonParser jsonParser, DeserializationContext context)
      throws IOException {
    ObjectCodec parserCodec = jsonParser.getCodec();
    JsonNode node = parserCodec.readTree(jsonParser);

    if (node.isTextual()) {
      return (Driver) User.fromSystem(node.textValue());
    }

    if (node.isObject()) {
      Driver driver = (Driver) User.fromSystem(node.get("id").asText());
      if (driver != null) {
        return driver;
      }

      return defaultDeserialize(parserCodec, context, node, Driver.class);
    }
    return null;
  }

}
