/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Duration;

public class DurationDeserializer extends JsonDeserializer<Duration> {

  @Override
  public Duration deserialize(JsonParser jsonParser, DeserializationContext context)
      throws IOException {
    return DurationSerializationUtil.durationFromString(jsonParser.getText());
  }
}
