/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.group.Group;
import com.geotab.model.entity.user.Driver;
import com.geotab.util.Util;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DutyStatusInfoDriverSerializer extends JsonSerializer<Driver> {

  @Override
  public void serialize(Driver driver, JsonGenerator jsonGenerator,
      SerializerProvider serializerProvider) throws IOException {
    if (driver.isSystemEntity()) {
      jsonGenerator.writeString(driver.getId().getId());
    } else {
      Map<String, Object> driverFields = Util.<String, Object>mapBuilder()
          .put("id", driver.getId() != null ? driver.getId().getId() : null)
          .put("isDriver", driver.getIsDriver())
          .put("driverGroups", convertDriverGroups(driver.getDriverGroups()))
          .build();
      jsonGenerator.writeObject(driverFields);
    }
  }

  private Collection<Id> convertDriverGroups(List<Group> driverGroups) {
    if (Util.isEmpty(driverGroups)) {
      return Collections.emptyList();
    }

    Collection<Entity> driverGroupsAsEntities = driverGroups.stream()
        .map(group -> (Entity) group)
        .collect(Collectors.toList());

    EntityCollectionAsIdCollectionSerializer entityCollectionAsIdCollectionSerializer =
        new EntityCollectionAsIdCollectionSerializer();

    return entityCollectionAsIdCollectionSerializer.convert(driverGroupsAsEntities);
  }
}
