/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.geotab.model.Id;
import java.io.IOException;

public class IdAsStringSerializer extends JsonSerializer<Id> {

  @Override
  public void serialize(Id v, JsonGenerator jg, SerializerProvider sp) throws IOException {
    if (v != null && v.getId() != null) jg.writeString(v.getId());
  }
}
