/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

public class LongDeserializer extends JsonDeserializer<Long> {

  @Override
  public Long deserialize(JsonParser jsonParser, DeserializationContext context)
      throws IOException {
    ObjectCodec parserCodec = jsonParser.getCodec();
    JsonNode node = parserCodec.readTree(jsonParser);

    if (node.isTextual()) {
      String longAsString = node.textValue();
      return stringToLong(longAsString);
    }

    if (node.isNumber()) {
      return node.asLong();
    }

    return null;
  }

  /**
   * Transform hex String to Long.
   */
  private static Long stringToLong(String longAsString) {
    if (longAsString == null) {
      return null;
    }
    long l = charToHex(longAsString.charAt(0));
    for (int i = 1; i < 16; i++) {
      l <<= 4;
      l |= charToHex(longAsString.charAt(i));
    }
    return l;
  }

  private static long charToHex(char c) {
    return c > 57 ? c - 0x61 + 10 : c - 0x30;
  }
}
