/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class LongSerializer extends JsonSerializer<Long> {

  @Override
  public void serialize(Long value, JsonGenerator jsonGenerator, SerializerProvider serializers)
      throws IOException {
    jsonGenerator.writeString(longToString(value));
  }

  /**
   * Converts a long to a hex representation.
   */
  private static String longToString(long version) {
    char[] chars = new char[16];
    int p = 0;
    for (int i = 7; i >= 0; i--) {
      int b = (int) (version >> (8 * i));
      chars[p++] = hexToChar(b >> 4);
      chars[p++] = hexToChar(b);
    }
    return new String(chars);
  }

  private static char hexToChar(int a) {
    a &= 0xf;
    return (char) (a > 9 ? a - 10 + 0x61 : a + 0x30);
  }
}
