/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.settings;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum OpenStreetMapStyle implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  /**
   * No style applied.
   */
  NONE("None"),

  /**
   * Slippy map layer view for OSM.
   */
  MAP_BOX("MapBox"),

  /**
   * OSM cycle view.
   */
  CYCLE("Cycle"),

  /**
   * OSM transport view.
   */
  TRANSPORT("Transport"),

  /**
   * Geotab satellite view.
   */
  SATELLITE("Satellite");

  private final String name;

  OpenStreetMapStyle(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
