/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.wifi;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Represents a specific usage tier for wifi hotspot rate plans.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class WifiUsageTier {

  /**
   * The name of this tier of wifi usage.
   */
  private String name;

  /**
   * The max usage limit, in units of kilobytes.
   */
  private Integer maxUsageKilobytes;

  /**
   * The dollar fee for this tier of wifi usage.
   */
  private Double fee;
}
