/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.http.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geotab.http.request.param.EmptyParameters;
import com.geotab.http.request.param.Parameters;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class BaseRequest<T extends Parameters> {
    private static final Parameters EMPTY_PARAMETERS = new EmptyParameters();
    protected Integer id;
    protected String method;
    protected T params;
    @JsonIgnore
    protected Map<String, Object> httpHeaders;

    public BaseRequest() {
        this(null, null, EMPTY_PARAMETERS, null);
    }

    public BaseRequest(Integer id, String method, T params) {
        this(id, method, params, null);
    }

    public BaseRequest(Integer id, String method, T params, Map<String, Object> httpHeaders) {
        this.id = id;
        this.method = method;
        this.params = Optional.ofNullable(params).orElse(EMPTY_PARAMETERS);
        this.httpHeaders = Optional.ofNullable(httpHeaders).orElse(new HashMap());
    }

    @Generated
    protected BaseRequest(BaseRequestBuilder<T, ?, ?> b) {
        this.id = ((BaseRequestBuilder)b).id;
        this.method = ((BaseRequestBuilder)b).method;
        this.params = ((BaseRequestBuilder)b).params;
        this.httpHeaders = ((BaseRequestBuilder)b).httpHeaders;
    }

    @Generated
    public static <T extends Parameters> BaseRequestBuilder<T, ?, ?> requestBuilder() {
        return new BaseRequestBuilderImpl();
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public T getParams() {
        return this.params;
    }

    @Generated
    public Map<String, Object> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Generated
    public BaseRequest<T> setId(Integer id) {
        this.id = id;
        return this;
    }

    @Generated
    public BaseRequest<T> setMethod(String method) {
        this.method = method;
        return this;
    }

    @Generated
    public BaseRequest<T> setParams(T params) {
        this.params = params;
        return this;
    }

    @JsonIgnore
    @Generated
    public BaseRequest<T> setHttpHeaders(Map<String, Object> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRequest)) {
            return false;
        }
        BaseRequest other = (BaseRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        T this$params = this.getParams();
        T other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        Map<String, Object> this$httpHeaders = this.getHttpHeaders();
        Map<String, Object> other$httpHeaders = other.getHttpHeaders();
        return !(this$httpHeaders == null ? other$httpHeaders != null : !((Object)this$httpHeaders).equals(other$httpHeaders));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        T $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        Map<String, Object> $httpHeaders = this.getHttpHeaders();
        result = result * 59 + ($httpHeaders == null ? 43 : ((Object)$httpHeaders).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseRequest(id=" + this.getId() + ", method=" + this.getMethod() + ", params=" + this.getParams() + ", httpHeaders=" + this.getHttpHeaders() + ")";
    }

    @Generated
    private static final class BaseRequestBuilderImpl<T extends Parameters>
    extends BaseRequestBuilder<T, BaseRequest<T>, BaseRequestBuilderImpl<T>> {
        @Generated
        private BaseRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected BaseRequestBuilderImpl<T> self() {
            return this;
        }

        @Override
        @Generated
        public BaseRequest<T> build() {
            return new BaseRequest(this);
        }
    }

    @Generated
    public static abstract class BaseRequestBuilder<T extends Parameters, C extends BaseRequest<T>, B extends BaseRequestBuilder<T, C, B>> {
        @Generated
        private Integer id;
        @Generated
        private String method;
        @Generated
        private T params;
        @Generated
        private Map<String, Object> httpHeaders;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(Integer id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B method(String method) {
            this.method = method;
            return this.self();
        }

        @Generated
        public B params(T params) {
            this.params = params;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B httpHeaders(Map<String, Object> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this.self();
        }

        @Generated
        public String toString() {
            return "BaseRequest.BaseRequestBuilder(id=" + this.id + ", method=" + this.method + ", params=" + this.params + ", httpHeaders=" + this.httpHeaders + ")";
        }
    }
}

