/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.certificate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.Entity;
import com.geotab.model.serialization.X509CertificateDeserializer;
import com.geotab.model.serialization.X509CertificateSerializer;
import java.security.cert.X509Certificate;
import lombok.Generated;

public class Certificate
extends Entity {
    private String issuer;
    @JsonSerialize(using=X509CertificateSerializer.class)
    @JsonDeserialize(using=X509CertificateDeserializer.class)
    private X509Certificate key;
    private String logOffUrl;
    private String logInUrl;
    @JsonProperty(value="isRoot")
    private boolean isRoot;

    @Generated
    protected Certificate(CertificateBuilder<?, ?> b) {
        super(b);
        this.issuer = ((CertificateBuilder)b).issuer;
        this.key = ((CertificateBuilder)b).key;
        this.logOffUrl = ((CertificateBuilder)b).logOffUrl;
        this.logInUrl = ((CertificateBuilder)b).logInUrl;
        this.isRoot = ((CertificateBuilder)b).isRoot;
    }

    @Generated
    public static CertificateBuilder<?, ?> builder() {
        return new CertificateBuilderImpl();
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public X509Certificate getKey() {
        return this.key;
    }

    @Generated
    public String getLogOffUrl() {
        return this.logOffUrl;
    }

    @Generated
    public String getLogInUrl() {
        return this.logInUrl;
    }

    @Generated
    public boolean isRoot() {
        return this.isRoot;
    }

    @Generated
    public Certificate setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @JsonDeserialize(using=X509CertificateDeserializer.class)
    @Generated
    public Certificate setKey(X509Certificate key) {
        this.key = key;
        return this;
    }

    @Generated
    public Certificate setLogOffUrl(String logOffUrl) {
        this.logOffUrl = logOffUrl;
        return this;
    }

    @Generated
    public Certificate setLogInUrl(String logInUrl) {
        this.logInUrl = logInUrl;
        return this;
    }

    @JsonProperty(value="isRoot")
    @Generated
    public Certificate setRoot(boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isRoot() != other.isRoot()) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        X509Certificate this$key = this.getKey();
        X509Certificate other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        String this$logOffUrl = this.getLogOffUrl();
        String other$logOffUrl = other.getLogOffUrl();
        if (this$logOffUrl == null ? other$logOffUrl != null : !this$logOffUrl.equals(other$logOffUrl)) {
            return false;
        }
        String this$logInUrl = this.getLogInUrl();
        String other$logInUrl = other.getLogInUrl();
        return !(this$logInUrl == null ? other$logInUrl != null : !this$logInUrl.equals(other$logInUrl));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Certificate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRoot() ? 79 : 97);
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        X509Certificate $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        String $logOffUrl = this.getLogOffUrl();
        result = result * 59 + ($logOffUrl == null ? 43 : $logOffUrl.hashCode());
        String $logInUrl = this.getLogInUrl();
        result = result * 59 + ($logInUrl == null ? 43 : $logInUrl.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Certificate(super=" + super.toString() + ", issuer=" + this.getIssuer() + ", key=" + this.getKey() + ", logOffUrl=" + this.getLogOffUrl() + ", logInUrl=" + this.getLogInUrl() + ", isRoot=" + this.isRoot() + ")";
    }

    @Generated
    public Certificate() {
    }

    @Generated
    private static final class CertificateBuilderImpl
    extends CertificateBuilder<Certificate, CertificateBuilderImpl> {
        @Generated
        private CertificateBuilderImpl() {
        }

        @Override
        @Generated
        protected CertificateBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Certificate build() {
            return new Certificate(this);
        }
    }

    @Generated
    public static abstract class CertificateBuilder<C extends Certificate, B extends CertificateBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        @Generated
        private String issuer;
        @Generated
        private X509Certificate key;
        @Generated
        private String logOffUrl;
        @Generated
        private String logInUrl;
        @Generated
        private boolean isRoot;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B issuer(String issuer) {
            this.issuer = issuer;
            return (B)this.self();
        }

        @JsonDeserialize(using=X509CertificateDeserializer.class)
        @Generated
        public B key(X509Certificate key) {
            this.key = key;
            return (B)this.self();
        }

        @Generated
        public B logOffUrl(String logOffUrl) {
            this.logOffUrl = logOffUrl;
            return (B)this.self();
        }

        @Generated
        public B logInUrl(String logInUrl) {
            this.logInUrl = logInUrl;
            return (B)this.self();
        }

        @JsonProperty(value="isRoot")
        @Generated
        public B isRoot(boolean isRoot) {
            this.isRoot = isRoot;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Certificate.CertificateBuilder(super=" + super.toString() + ", issuer=" + this.issuer + ", key=" + this.key + ", logOffUrl=" + this.logOffUrl + ", logInUrl=" + this.logInUrl + ", isRoot=" + this.isRoot + ")";
        }
    }
}

