/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.model.entity.device.VehicleFeatureCategory;
import com.geotab.util.Util;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;

public class DeviceFlags {
    public static final List<VehicleFeatureCategory> GARMIN_FEATURES = Util.listOf(VehicleFeatureCategory.GARMIN, VehicleFeatureCategory.GARMIN_HOS);
    public static final List<VehicleFeatureCategory> HOS_FEATURES = Util.listOf(VehicleFeatureCategory.GEOTAB_DRIVE_HOS, VehicleFeatureCategory.GARMIN_HOS, VehicleFeatureCategory.HOS);
    private List<VehicleFeatureCategory> activeFeatures;
    @JsonProperty(value="isActiveTrackingAllowed")
    private boolean isActiveTrackingAllowed;
    @JsonProperty(value="isEngineAllowed")
    private boolean isEngineAllowed;
    @JsonProperty(value="isGarminAllowed")
    private boolean isGarminAllowed;
    @JsonProperty(value="isHOSAllowed")
    private boolean isHOSAllowed;
    @JsonProperty(value="isIridiumAllowed")
    private boolean isIridiumAllowed;
    @JsonProperty(value="isOdometerAllowed")
    private boolean isOdometerAllowed;
    @JsonProperty(value="isTripDetailAllowed")
    private boolean isTripDetailAllowed;
    @JsonProperty(value="isUIAllowed")
    private boolean isUIAllowed;
    @JsonProperty(value="isVINAllowed")
    private boolean isVINAllowed;
    private List<String> ratePlans;

    public DeviceFlags(List<VehicleFeatureCategory> activeFeatures, List<VehicleFeatureCategory> allowedFeatures, List<String> restrictions) {
        for (String item : restrictions) {
            switch (item.toLowerCase(Locale.ROOT)) {
                case "nocheckmate": {
                    this.isUIAllowed = false;
                    break;
                }
                case "nocheckmatevin": {
                    this.isVINAllowed = false;
                    break;
                }
                case "nocheckmateodo": {
                    this.isOdometerAllowed = false;
                    break;
                }
                case "nocheckmateengine": {
                    this.isEngineAllowed = false;
                    break;
                }
                case "nocheckmatetripdetail": {
                    this.isTripDetailAllowed = false;
                    break;
                }
            }
        }
        this.isGarminAllowed = !Util.intersect(allowedFeatures, GARMIN_FEATURES).isEmpty();
        this.isHOSAllowed = !Util.intersect(allowedFeatures, HOS_FEATURES).isEmpty();
        this.isIridiumAllowed = allowedFeatures != null && allowedFeatures.contains(VehicleFeatureCategory.IRIDIUM);
        this.isActiveTrackingAllowed = allowedFeatures != null && allowedFeatures.contains(VehicleFeatureCategory.GO_ACTIVE);
        this.activeFeatures = Optional.ofNullable(activeFeatures).orElse(Util.listOf(new VehicleFeatureCategory[0]));
    }

    @Generated
    public static DeviceFlagsBuilder builder() {
        return new DeviceFlagsBuilder();
    }

    @Generated
    public List<VehicleFeatureCategory> getActiveFeatures() {
        return this.activeFeatures;
    }

    @Generated
    public boolean isActiveTrackingAllowed() {
        return this.isActiveTrackingAllowed;
    }

    @Generated
    public boolean isEngineAllowed() {
        return this.isEngineAllowed;
    }

    @Generated
    public boolean isGarminAllowed() {
        return this.isGarminAllowed;
    }

    @Generated
    public boolean isHOSAllowed() {
        return this.isHOSAllowed;
    }

    @Generated
    public boolean isIridiumAllowed() {
        return this.isIridiumAllowed;
    }

    @Generated
    public boolean isOdometerAllowed() {
        return this.isOdometerAllowed;
    }

    @Generated
    public boolean isTripDetailAllowed() {
        return this.isTripDetailAllowed;
    }

    @Generated
    public boolean isUIAllowed() {
        return this.isUIAllowed;
    }

    @Generated
    public boolean isVINAllowed() {
        return this.isVINAllowed;
    }

    @Generated
    public List<String> getRatePlans() {
        return this.ratePlans;
    }

    @Generated
    public DeviceFlags setActiveFeatures(List<VehicleFeatureCategory> activeFeatures) {
        this.activeFeatures = activeFeatures;
        return this;
    }

    @JsonProperty(value="isActiveTrackingAllowed")
    @Generated
    public DeviceFlags setActiveTrackingAllowed(boolean isActiveTrackingAllowed) {
        this.isActiveTrackingAllowed = isActiveTrackingAllowed;
        return this;
    }

    @JsonProperty(value="isEngineAllowed")
    @Generated
    public DeviceFlags setEngineAllowed(boolean isEngineAllowed) {
        this.isEngineAllowed = isEngineAllowed;
        return this;
    }

    @JsonProperty(value="isGarminAllowed")
    @Generated
    public DeviceFlags setGarminAllowed(boolean isGarminAllowed) {
        this.isGarminAllowed = isGarminAllowed;
        return this;
    }

    @JsonProperty(value="isHOSAllowed")
    @Generated
    public DeviceFlags setHOSAllowed(boolean isHOSAllowed) {
        this.isHOSAllowed = isHOSAllowed;
        return this;
    }

    @JsonProperty(value="isIridiumAllowed")
    @Generated
    public DeviceFlags setIridiumAllowed(boolean isIridiumAllowed) {
        this.isIridiumAllowed = isIridiumAllowed;
        return this;
    }

    @JsonProperty(value="isOdometerAllowed")
    @Generated
    public DeviceFlags setOdometerAllowed(boolean isOdometerAllowed) {
        this.isOdometerAllowed = isOdometerAllowed;
        return this;
    }

    @JsonProperty(value="isTripDetailAllowed")
    @Generated
    public DeviceFlags setTripDetailAllowed(boolean isTripDetailAllowed) {
        this.isTripDetailAllowed = isTripDetailAllowed;
        return this;
    }

    @JsonProperty(value="isUIAllowed")
    @Generated
    public DeviceFlags setUIAllowed(boolean isUIAllowed) {
        this.isUIAllowed = isUIAllowed;
        return this;
    }

    @JsonProperty(value="isVINAllowed")
    @Generated
    public DeviceFlags setVINAllowed(boolean isVINAllowed) {
        this.isVINAllowed = isVINAllowed;
        return this;
    }

    @Generated
    public DeviceFlags setRatePlans(List<String> ratePlans) {
        this.ratePlans = ratePlans;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceFlags)) {
            return false;
        }
        DeviceFlags other = (DeviceFlags)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActiveTrackingAllowed() != other.isActiveTrackingAllowed()) {
            return false;
        }
        if (this.isEngineAllowed() != other.isEngineAllowed()) {
            return false;
        }
        if (this.isGarminAllowed() != other.isGarminAllowed()) {
            return false;
        }
        if (this.isHOSAllowed() != other.isHOSAllowed()) {
            return false;
        }
        if (this.isIridiumAllowed() != other.isIridiumAllowed()) {
            return false;
        }
        if (this.isOdometerAllowed() != other.isOdometerAllowed()) {
            return false;
        }
        if (this.isTripDetailAllowed() != other.isTripDetailAllowed()) {
            return false;
        }
        if (this.isUIAllowed() != other.isUIAllowed()) {
            return false;
        }
        if (this.isVINAllowed() != other.isVINAllowed()) {
            return false;
        }
        List<VehicleFeatureCategory> this$activeFeatures = this.getActiveFeatures();
        List<VehicleFeatureCategory> other$activeFeatures = other.getActiveFeatures();
        if (this$activeFeatures == null ? other$activeFeatures != null : !((Object)this$activeFeatures).equals(other$activeFeatures)) {
            return false;
        }
        List<String> this$ratePlans = this.getRatePlans();
        List<String> other$ratePlans = other.getRatePlans();
        return !(this$ratePlans == null ? other$ratePlans != null : !((Object)this$ratePlans).equals(other$ratePlans));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceFlags;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActiveTrackingAllowed() ? 79 : 97);
        result = result * 59 + (this.isEngineAllowed() ? 79 : 97);
        result = result * 59 + (this.isGarminAllowed() ? 79 : 97);
        result = result * 59 + (this.isHOSAllowed() ? 79 : 97);
        result = result * 59 + (this.isIridiumAllowed() ? 79 : 97);
        result = result * 59 + (this.isOdometerAllowed() ? 79 : 97);
        result = result * 59 + (this.isTripDetailAllowed() ? 79 : 97);
        result = result * 59 + (this.isUIAllowed() ? 79 : 97);
        result = result * 59 + (this.isVINAllowed() ? 79 : 97);
        List<VehicleFeatureCategory> $activeFeatures = this.getActiveFeatures();
        result = result * 59 + ($activeFeatures == null ? 43 : ((Object)$activeFeatures).hashCode());
        List<String> $ratePlans = this.getRatePlans();
        result = result * 59 + ($ratePlans == null ? 43 : ((Object)$ratePlans).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeviceFlags(activeFeatures=" + this.getActiveFeatures() + ", isActiveTrackingAllowed=" + this.isActiveTrackingAllowed() + ", isEngineAllowed=" + this.isEngineAllowed() + ", isGarminAllowed=" + this.isGarminAllowed() + ", isHOSAllowed=" + this.isHOSAllowed() + ", isIridiumAllowed=" + this.isIridiumAllowed() + ", isOdometerAllowed=" + this.isOdometerAllowed() + ", isTripDetailAllowed=" + this.isTripDetailAllowed() + ", isUIAllowed=" + this.isUIAllowed() + ", isVINAllowed=" + this.isVINAllowed() + ", ratePlans=" + this.getRatePlans() + ")";
    }

    @Generated
    public DeviceFlags() {
    }

    @Generated
    public DeviceFlags(List<VehicleFeatureCategory> activeFeatures, boolean isActiveTrackingAllowed, boolean isEngineAllowed, boolean isGarminAllowed, boolean isHOSAllowed, boolean isIridiumAllowed, boolean isOdometerAllowed, boolean isTripDetailAllowed, boolean isUIAllowed, boolean isVINAllowed, List<String> ratePlans) {
        this.activeFeatures = activeFeatures;
        this.isActiveTrackingAllowed = isActiveTrackingAllowed;
        this.isEngineAllowed = isEngineAllowed;
        this.isGarminAllowed = isGarminAllowed;
        this.isHOSAllowed = isHOSAllowed;
        this.isIridiumAllowed = isIridiumAllowed;
        this.isOdometerAllowed = isOdometerAllowed;
        this.isTripDetailAllowed = isTripDetailAllowed;
        this.isUIAllowed = isUIAllowed;
        this.isVINAllowed = isVINAllowed;
        this.ratePlans = ratePlans;
    }

    @Generated
    public static class DeviceFlagsBuilder {
        @Generated
        private List<VehicleFeatureCategory> activeFeatures;
        @Generated
        private boolean isActiveTrackingAllowed;
        @Generated
        private boolean isEngineAllowed;
        @Generated
        private boolean isGarminAllowed;
        @Generated
        private boolean isHOSAllowed;
        @Generated
        private boolean isIridiumAllowed;
        @Generated
        private boolean isOdometerAllowed;
        @Generated
        private boolean isTripDetailAllowed;
        @Generated
        private boolean isUIAllowed;
        @Generated
        private boolean isVINAllowed;
        @Generated
        private List<String> ratePlans;

        @Generated
        DeviceFlagsBuilder() {
        }

        @Generated
        public DeviceFlagsBuilder activeFeatures(List<VehicleFeatureCategory> activeFeatures) {
            this.activeFeatures = activeFeatures;
            return this;
        }

        @JsonProperty(value="isActiveTrackingAllowed")
        @Generated
        public DeviceFlagsBuilder isActiveTrackingAllowed(boolean isActiveTrackingAllowed) {
            this.isActiveTrackingAllowed = isActiveTrackingAllowed;
            return this;
        }

        @JsonProperty(value="isEngineAllowed")
        @Generated
        public DeviceFlagsBuilder isEngineAllowed(boolean isEngineAllowed) {
            this.isEngineAllowed = isEngineAllowed;
            return this;
        }

        @JsonProperty(value="isGarminAllowed")
        @Generated
        public DeviceFlagsBuilder isGarminAllowed(boolean isGarminAllowed) {
            this.isGarminAllowed = isGarminAllowed;
            return this;
        }

        @JsonProperty(value="isHOSAllowed")
        @Generated
        public DeviceFlagsBuilder isHOSAllowed(boolean isHOSAllowed) {
            this.isHOSAllowed = isHOSAllowed;
            return this;
        }

        @JsonProperty(value="isIridiumAllowed")
        @Generated
        public DeviceFlagsBuilder isIridiumAllowed(boolean isIridiumAllowed) {
            this.isIridiumAllowed = isIridiumAllowed;
            return this;
        }

        @JsonProperty(value="isOdometerAllowed")
        @Generated
        public DeviceFlagsBuilder isOdometerAllowed(boolean isOdometerAllowed) {
            this.isOdometerAllowed = isOdometerAllowed;
            return this;
        }

        @JsonProperty(value="isTripDetailAllowed")
        @Generated
        public DeviceFlagsBuilder isTripDetailAllowed(boolean isTripDetailAllowed) {
            this.isTripDetailAllowed = isTripDetailAllowed;
            return this;
        }

        @JsonProperty(value="isUIAllowed")
        @Generated
        public DeviceFlagsBuilder isUIAllowed(boolean isUIAllowed) {
            this.isUIAllowed = isUIAllowed;
            return this;
        }

        @JsonProperty(value="isVINAllowed")
        @Generated
        public DeviceFlagsBuilder isVINAllowed(boolean isVINAllowed) {
            this.isVINAllowed = isVINAllowed;
            return this;
        }

        @Generated
        public DeviceFlagsBuilder ratePlans(List<String> ratePlans) {
            this.ratePlans = ratePlans;
            return this;
        }

        @Generated
        public DeviceFlags build() {
            return new DeviceFlags(this.activeFeatures, this.isActiveTrackingAllowed, this.isEngineAllowed, this.isGarminAllowed, this.isHOSAllowed, this.isIridiumAllowed, this.isOdometerAllowed, this.isTripDetailAllowed, this.isUIAllowed, this.isVINAllowed, this.ratePlans);
        }

        @Generated
        public String toString() {
            return "DeviceFlags.DeviceFlagsBuilder(activeFeatures=" + this.activeFeatures + ", isActiveTrackingAllowed=" + this.isActiveTrackingAllowed + ", isEngineAllowed=" + this.isEngineAllowed + ", isGarminAllowed=" + this.isGarminAllowed + ", isHOSAllowed=" + this.isHOSAllowed + ", isIridiumAllowed=" + this.isIridiumAllowed + ", isOdometerAllowed=" + this.isOdometerAllowed + ", isTripDetailAllowed=" + this.isTripDetailAllowed + ", isUIAllowed=" + this.isUIAllowed + ", isVINAllowed=" + this.isVINAllowed + ", ratePlans=" + this.ratePlans + ")";
        }
    }
}

