/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.model.entity.device.DigitalAuxiliariesAware;
import com.geotab.model.entity.device.GoCurve;
import com.geotab.util.DeviceDefaultsUtil;
import java.util.Arrays;
import lombok.Generated;

public abstract class GoCurveAuxiliary
extends GoCurve
implements DigitalAuxiliariesAware {
    protected double[] auxWarningSpeed;
    protected boolean[] enableAuxWarning;
    protected boolean enableControlExternalRelay;
    protected int externalDeviceShutDownDelay;
    protected int immobilizeArming;
    protected boolean immobilizeUnit;
    @JsonProperty(value="isAuxIgnTrigger")
    protected boolean[] isAuxIgnTrigger;
    @JsonProperty(value="isAuxInverted")
    protected boolean[] isAuxInverted;

    @Override
    public GoCurveAuxiliary setAuxWarningSpeed(double[] auxWarningSpeed) {
        this.auxWarningSpeed = GoCurveAuxiliary.checkAndPadAuxArray(auxWarningSpeed);
        return this;
    }

    @Override
    public GoCurveAuxiliary setEnableAuxWarning(boolean[] enableAuxWarning) {
        this.enableAuxWarning = GoCurveAuxiliary.checkAndPadAuxArray(enableAuxWarning);
        return this;
    }

    public GoCurveAuxiliary setAuxIgnTrigger(boolean[] isAuxIgnTrigger) {
        this.isAuxIgnTrigger = GoCurveAuxiliary.checkAndPadAuxIgnArray(isAuxIgnTrigger);
        return this;
    }

    @Override
    public GoCurveAuxiliary setIsAuxInverted(boolean[] isAuxInverted) {
        this.isAuxInverted = GoCurveAuxiliary.checkAndPadAuxArray(isAuxInverted);
        return this;
    }

    @Override
    public void populateDefaults() {
        super.populateDefaults();
        DeviceDefaultsUtil.addAuxiliaryDefaults(this);
    }

    @Generated
    protected GoCurveAuxiliary(GoCurveAuxiliaryBuilder<?, ?> b) {
        super((GoCurve.GoCurveBuilder<?, ?>)b);
        this.auxWarningSpeed = ((GoCurveAuxiliaryBuilder)b).auxWarningSpeed;
        this.enableAuxWarning = ((GoCurveAuxiliaryBuilder)b).enableAuxWarning;
        this.enableControlExternalRelay = ((GoCurveAuxiliaryBuilder)b).enableControlExternalRelay;
        this.externalDeviceShutDownDelay = ((GoCurveAuxiliaryBuilder)b).externalDeviceShutDownDelay;
        this.immobilizeArming = ((GoCurveAuxiliaryBuilder)b).immobilizeArming;
        this.immobilizeUnit = ((GoCurveAuxiliaryBuilder)b).immobilizeUnit;
        this.isAuxIgnTrigger = ((GoCurveAuxiliaryBuilder)b).isAuxIgnTrigger;
        this.isAuxInverted = ((GoCurveAuxiliaryBuilder)b).isAuxInverted;
    }

    @Override
    @Generated
    public double[] getAuxWarningSpeed() {
        return this.auxWarningSpeed;
    }

    @Override
    @Generated
    public boolean[] getEnableAuxWarning() {
        return this.enableAuxWarning;
    }

    @Override
    @Generated
    public boolean isEnableControlExternalRelay() {
        return this.enableControlExternalRelay;
    }

    @Override
    @Generated
    public int getExternalDeviceShutDownDelay() {
        return this.externalDeviceShutDownDelay;
    }

    @Override
    @Generated
    public int getImmobilizeArming() {
        return this.immobilizeArming;
    }

    @Override
    @Generated
    public boolean isImmobilizeUnit() {
        return this.immobilizeUnit;
    }

    @Override
    @Generated
    public boolean[] getIsAuxIgnTrigger() {
        return this.isAuxIgnTrigger;
    }

    @Override
    @Generated
    public boolean[] getIsAuxInverted() {
        return this.isAuxInverted;
    }

    @Override
    @Generated
    public GoCurveAuxiliary setEnableControlExternalRelay(boolean enableControlExternalRelay) {
        this.enableControlExternalRelay = enableControlExternalRelay;
        return this;
    }

    @Override
    @Generated
    public GoCurveAuxiliary setExternalDeviceShutDownDelay(int externalDeviceShutDownDelay) {
        this.externalDeviceShutDownDelay = externalDeviceShutDownDelay;
        return this;
    }

    @Override
    @Generated
    public GoCurveAuxiliary setImmobilizeArming(int immobilizeArming) {
        this.immobilizeArming = immobilizeArming;
        return this;
    }

    @Override
    @Generated
    public GoCurveAuxiliary setImmobilizeUnit(boolean immobilizeUnit) {
        this.immobilizeUnit = immobilizeUnit;
        return this;
    }

    @Override
    @JsonProperty(value="isAuxIgnTrigger")
    @Generated
    public GoCurveAuxiliary setIsAuxIgnTrigger(boolean[] isAuxIgnTrigger) {
        this.isAuxIgnTrigger = isAuxIgnTrigger;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GoCurveAuxiliary)) {
            return false;
        }
        GoCurveAuxiliary other = (GoCurveAuxiliary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnableControlExternalRelay() != other.isEnableControlExternalRelay()) {
            return false;
        }
        if (this.getExternalDeviceShutDownDelay() != other.getExternalDeviceShutDownDelay()) {
            return false;
        }
        if (this.getImmobilizeArming() != other.getImmobilizeArming()) {
            return false;
        }
        if (this.isImmobilizeUnit() != other.isImmobilizeUnit()) {
            return false;
        }
        if (!Arrays.equals(this.getAuxWarningSpeed(), other.getAuxWarningSpeed())) {
            return false;
        }
        if (!Arrays.equals(this.getEnableAuxWarning(), other.getEnableAuxWarning())) {
            return false;
        }
        if (!Arrays.equals(this.getIsAuxIgnTrigger(), other.getIsAuxIgnTrigger())) {
            return false;
        }
        return Arrays.equals(this.getIsAuxInverted(), other.getIsAuxInverted());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GoCurveAuxiliary;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnableControlExternalRelay() ? 79 : 97);
        result = result * 59 + this.getExternalDeviceShutDownDelay();
        result = result * 59 + this.getImmobilizeArming();
        result = result * 59 + (this.isImmobilizeUnit() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getAuxWarningSpeed());
        result = result * 59 + Arrays.hashCode(this.getEnableAuxWarning());
        result = result * 59 + Arrays.hashCode(this.getIsAuxIgnTrigger());
        result = result * 59 + Arrays.hashCode(this.getIsAuxInverted());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GoCurveAuxiliary(super=" + super.toString() + ", auxWarningSpeed=" + Arrays.toString(this.getAuxWarningSpeed()) + ", enableAuxWarning=" + Arrays.toString(this.getEnableAuxWarning()) + ", enableControlExternalRelay=" + this.isEnableControlExternalRelay() + ", externalDeviceShutDownDelay=" + this.getExternalDeviceShutDownDelay() + ", immobilizeArming=" + this.getImmobilizeArming() + ", immobilizeUnit=" + this.isImmobilizeUnit() + ", isAuxIgnTrigger=" + Arrays.toString(this.getIsAuxIgnTrigger()) + ", isAuxInverted=" + Arrays.toString(this.getIsAuxInverted()) + ")";
    }

    @Generated
    public GoCurveAuxiliary() {
    }

    @Generated
    public static abstract class GoCurveAuxiliaryBuilder<C extends GoCurveAuxiliary, B extends GoCurveAuxiliaryBuilder<C, B>>
    extends GoCurve.GoCurveBuilder<C, B> {
        @Generated
        private double[] auxWarningSpeed;
        @Generated
        private boolean[] enableAuxWarning;
        @Generated
        private boolean enableControlExternalRelay;
        @Generated
        private int externalDeviceShutDownDelay;
        @Generated
        private int immobilizeArming;
        @Generated
        private boolean immobilizeUnit;
        @Generated
        private boolean[] isAuxIgnTrigger;
        @Generated
        private boolean[] isAuxInverted;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B auxWarningSpeed(double[] auxWarningSpeed) {
            this.auxWarningSpeed = auxWarningSpeed;
            return (B)this.self();
        }

        @Generated
        public B enableAuxWarning(boolean[] enableAuxWarning) {
            this.enableAuxWarning = enableAuxWarning;
            return (B)this.self();
        }

        @Generated
        public B enableControlExternalRelay(boolean enableControlExternalRelay) {
            this.enableControlExternalRelay = enableControlExternalRelay;
            return (B)this.self();
        }

        @Generated
        public B externalDeviceShutDownDelay(int externalDeviceShutDownDelay) {
            this.externalDeviceShutDownDelay = externalDeviceShutDownDelay;
            return (B)this.self();
        }

        @Generated
        public B immobilizeArming(int immobilizeArming) {
            this.immobilizeArming = immobilizeArming;
            return (B)this.self();
        }

        @Generated
        public B immobilizeUnit(boolean immobilizeUnit) {
            this.immobilizeUnit = immobilizeUnit;
            return (B)this.self();
        }

        @JsonProperty(value="isAuxIgnTrigger")
        @Generated
        public B isAuxIgnTrigger(boolean[] isAuxIgnTrigger) {
            this.isAuxIgnTrigger = isAuxIgnTrigger;
            return (B)this.self();
        }

        @JsonProperty(value="isAuxInverted")
        @Generated
        public B isAuxInverted(boolean[] isAuxInverted) {
            this.isAuxInverted = isAuxInverted;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "GoCurveAuxiliary.GoCurveAuxiliaryBuilder(super=" + super.toString() + ", auxWarningSpeed=" + Arrays.toString(this.auxWarningSpeed) + ", enableAuxWarning=" + Arrays.toString(this.enableAuxWarning) + ", enableControlExternalRelay=" + this.enableControlExternalRelay + ", externalDeviceShutDownDelay=" + this.externalDeviceShutDownDelay + ", immobilizeArming=" + this.immobilizeArming + ", immobilizeUnit=" + this.immobilizeUnit + ", isAuxIgnTrigger=" + Arrays.toString(this.isAuxIgnTrigger) + ", isAuxInverted=" + Arrays.toString(this.isAuxInverted) + ")";
        }
    }
}

