/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.diagnostic;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DiagnosticType implements HasName
{
    NONE("None"),
    SID("Sid"),
    PID("Pid"),
    GO_DIAGNOSTIC("GoDiagnostic"),
    DATA_DIAGNOSTIC("DataDiagnostic"),
    SUSPECT_PARAMETER("SuspectParameter"),
    OBD_FAULT("ObdFault"),
    GO_FAULT("GoFault"),
    OBD_WWH_FAULT("ObdWwhFault"),
    PROPRIETARY_FAULT("ProprietaryFault"),
    LEGACY_FAULT("LegacyFault"),
    GMCCC_FAULT("GmcccFault"),
    BRP_FAULT("BrpFault"),
    AI_MODEL("AiModel"),
    LEVC_FAULT("LevcFault");

    @Generated
    private static final Logger log;
    private final String name;

    private DiagnosticType(String name) {
        this.name = name;
    }

    @Override
    @JsonValue
    public String getName() {
        return this.name;
    }

    public static DiagnosticType findOrDefault(String name) {
        if (Util.isEmpty(name)) {
            log.warn("Empty value is not recognized for {} enum; returning default {}", (Object)DiagnosticType.class.getSimpleName(), (Object)NONE);
            return NONE;
        }
        for (DiagnosticType diagnosticType : DiagnosticType.values()) {
            if (!diagnosticType.getName().equalsIgnoreCase(name.trim())) continue;
            return diagnosticType;
        }
        log.warn("{} is not recognized for {} enum; returning default {}", new Object[]{name, DiagnosticType.class.getSimpleName(), NONE});
        return NONE;
    }

    static {
        log = LoggerFactory.getLogger(DiagnosticType.class);
    }
}

