/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.file;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Status implements HasName
{
    UNKNOWN("Unknown", 0),
    PROCESSING("Processing", 1),
    READY("Ready", 2),
    NO_FILE("NoFile", 3);

    @Generated
    private static final Logger log;
    private final String name;
    private final int code;

    private Status(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    @JsonValue
    public String getName() {
        return this.name;
    }

    public static Status findOrDefault(String name) {
        if (Util.isEmpty(name)) {
            log.warn("Empty value is not recognized for {} enum; returning default {}", (Object)Status.class.getSimpleName(), (Object)UNKNOWN);
            return UNKNOWN;
        }
        for (Status status : Status.values()) {
            if (!status.getName().equalsIgnoreCase(name.trim())) continue;
            return status;
        }
        log.warn("{} is not recognized for {} enum; returning default {}", new Object[]{name, Status.class.getSimpleName(), UNKNOWN});
        return UNKNOWN;
    }

    static {
        log = LoggerFactory.getLogger(Status.class);
    }
}

