/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.fuel;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FuelTransactionProductType implements HasName
{
    UNKNOWN("Unknown", 0),
    NON_FUEL("NonFuel", 1),
    REGULAR("Regular", 2),
    MIDGRADE("Midgrade", 4),
    PREMIUM("Premium", 8),
    SUPER("Super", 16),
    DIESEL("Diesel", 32),
    E85("E85", 64),
    CNG("CNG", 128),
    LPG("LPG", 256),
    HYDROGEN("Hydrogen", 512),
    DIESEL_EXHAUST_FLUID("DieselExhaustFluid", 1024),
    ELECTRIC("Electric", 2048);

    @Generated
    private static final Logger log;
    private final String name;
    private final int code;

    private FuelTransactionProductType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    @JsonValue
    public String getName() {
        return this.name;
    }

    public static FuelTransactionProductType findOrDefault(String name) {
        if (Util.isEmpty(name)) {
            log.warn("Empty value is not recognized for {} enum; returning default {}", (Object)FuelTransactionProductType.class.getSimpleName(), (Object)UNKNOWN);
            return UNKNOWN;
        }
        for (FuelTransactionProductType fuelTransactionProductType : FuelTransactionProductType.values()) {
            if (!fuelTransactionProductType.getName().equalsIgnoreCase(name.trim())) continue;
            return fuelTransactionProductType;
        }
        log.warn("{} is not recognized for {} enum; returning default {}", new Object[]{name, FuelTransactionProductType.class.getSimpleName(), UNKNOWN});
        return UNKNOWN;
    }

    static {
        log = LoggerFactory.getLogger(FuelTransactionProductType.class);
    }
}

