/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.logrecord;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geotab.model.coordinate.Coordinate;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.device.Device;
import com.geotab.util.LogRecordValidator;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;

public class LogRecord
extends Entity {
    private Double latitude;
    private Double longitude;
    private Float speed;
    private Device device;
    private LocalDateTime dateTime;

    public static double distanceBetweenPoints(double longitudeA, double latitudeA, double longitudeB, double latitudeB) {
        return Coordinate.distanceBetween(longitudeA, latitudeA, longitudeB, latitudeB) / 1000.0;
    }

    public static List<Coordinate> getExtent(List<LogRecord> logRecords) {
        double xMin = Double.MAX_VALUE;
        double xMax = Double.MIN_VALUE;
        double yMin = Double.MAX_VALUE;
        double yMax = Double.MIN_VALUE;
        for (LogRecord log : logRecords) {
            double x = log.longitude;
            double y = log.latitude;
            if (xMin != Double.MAX_VALUE) {
                if (xMin > x) {
                    if (!LogRecordValidator.isValidCoordinateRange(x, y)) continue;
                    xMin = x;
                } else if (xMax < x) {
                    if (!LogRecordValidator.isValidCoordinateRange(x, y)) continue;
                    xMax = x;
                }
                if (yMin > y) {
                    if (!LogRecordValidator.isValidCoordinateRange(x, y)) continue;
                    yMin = y;
                    continue;
                }
                if (!(yMax < y) || !LogRecordValidator.isValidCoordinateRange(x, y)) continue;
                yMax = y;
                continue;
            }
            if (!LogRecordValidator.isValidCoordinateRange(x, y)) continue;
            xMax = xMin = x;
            yMax = yMin = y;
        }
        if (xMin == Double.MAX_VALUE) {
            return null;
        }
        return Coordinate.rectangleFromLtrb(xMin, yMax, xMax, yMin);
    }

    @JsonIgnore
    public double distanceTo(LogRecord logRecord) {
        return LogRecord.distanceBetweenPoints(this.longitude, this.latitude, logRecord.longitude, logRecord.latitude);
    }

    @JsonIgnore
    public double distanceTo(Coordinate coordinate) {
        return LogRecord.distanceBetweenPoints(this.longitude, this.latitude, coordinate.getX(), coordinate.getY());
    }

    @JsonIgnore
    public Coordinate toSimpleCoordinate() {
        if (this.longitude == null || this.latitude == null) {
            return null;
        }
        return new Coordinate(this.longitude, this.latitude);
    }

    @Generated
    protected LogRecord(LogRecordBuilder<?, ?> b) {
        super(b);
        this.latitude = ((LogRecordBuilder)b).latitude;
        this.longitude = ((LogRecordBuilder)b).longitude;
        this.speed = ((LogRecordBuilder)b).speed;
        this.device = ((LogRecordBuilder)b).device;
        this.dateTime = ((LogRecordBuilder)b).dateTime;
    }

    @Generated
    public static LogRecordBuilder<?, ?> builder() {
        return new LogRecordBuilderImpl();
    }

    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Generated
    public Float getSpeed() {
        return this.speed;
    }

    @Generated
    public Device getDevice() {
        return this.device;
    }

    @Generated
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Generated
    public LogRecord setLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    @Generated
    public LogRecord setLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    @Generated
    public LogRecord setSpeed(Float speed) {
        this.speed = speed;
        return this;
    }

    @Generated
    public LogRecord setDevice(Device device) {
        this.device = device;
        return this;
    }

    @Generated
    public LogRecord setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogRecord)) {
            return false;
        }
        LogRecord other = (LogRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Float this$speed = this.getSpeed();
        Float other$speed = other.getSpeed();
        if (this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed)) {
            return false;
        }
        Device this$device = this.getDevice();
        Device other$device = other.getDevice();
        if (this$device == null ? other$device != null : !((Object)this$device).equals(other$device)) {
            return false;
        }
        LocalDateTime this$dateTime = this.getDateTime();
        LocalDateTime other$dateTime = other.getDateTime();
        return !(this$dateTime == null ? other$dateTime != null : !((Object)this$dateTime).equals(other$dateTime));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogRecord;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Float $speed = this.getSpeed();
        result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
        Device $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
        LocalDateTime $dateTime = this.getDateTime();
        result = result * 59 + ($dateTime == null ? 43 : ((Object)$dateTime).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LogRecord(super=" + super.toString() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", speed=" + this.getSpeed() + ", device=" + this.getDevice() + ", dateTime=" + this.getDateTime() + ")";
    }

    @Generated
    public LogRecord() {
    }

    @Generated
    private static final class LogRecordBuilderImpl
    extends LogRecordBuilder<LogRecord, LogRecordBuilderImpl> {
        @Generated
        private LogRecordBuilderImpl() {
        }

        @Override
        @Generated
        protected LogRecordBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LogRecord build() {
            return new LogRecord(this);
        }
    }

    @Generated
    public static abstract class LogRecordBuilder<C extends LogRecord, B extends LogRecordBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        @Generated
        private Double latitude;
        @Generated
        private Double longitude;
        @Generated
        private Float speed;
        @Generated
        private Device device;
        @Generated
        private LocalDateTime dateTime;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B latitude(Double latitude) {
            this.latitude = latitude;
            return (B)this.self();
        }

        @Generated
        public B longitude(Double longitude) {
            this.longitude = longitude;
            return (B)this.self();
        }

        @Generated
        public B speed(Float speed) {
            this.speed = speed;
            return (B)this.self();
        }

        @Generated
        public B device(Device device) {
            this.device = device;
            return (B)this.self();
        }

        @Generated
        public B dateTime(LocalDateTime dateTime) {
            this.dateTime = dateTime;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LogRecord.LogRecordBuilder(super=" + super.toString() + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", speed=" + this.speed + ", device=" + this.device + ", dateTime=" + this.dateTime + ")";
        }
    }
}

