/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.rule;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.drawing.Color;
import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.condition.Condition;
import com.geotab.model.entity.group.Group;
import com.geotab.model.entity.rule.ExceptionRuleBaseType;
import com.geotab.model.entity.rule.NoRule;
import com.geotab.model.serialization.EntityCollectionAsIdCollectionSerializer;
import com.geotab.util.Util;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;

public class Rule
extends NameEntityWithVersion {
    private Condition condition;
    private LocalDateTime activeFrom;
    private LocalDateTime activeTo;
    private ExceptionRuleBaseType baseType;
    private Color color;
    private String comment;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    private List<Group> groups;

    public Rule(String id) {
        this.setId(new Id(id));
        this.setName(id);
    }

    public static Rule fromSystem(String id) {
        if (Util.isEmpty(id)) {
            return null;
        }
        if ("NoRuleId".equals(id)) {
            return NoRule.getInstance();
        }
        return null;
    }

    @Generated
    protected Rule(RuleBuilder<?, ?> b) {
        super((NameEntityWithVersion.NameEntityWithVersionBuilder<?, ?>)b);
        this.condition = ((RuleBuilder)b).condition;
        this.activeFrom = ((RuleBuilder)b).activeFrom;
        this.activeTo = ((RuleBuilder)b).activeTo;
        this.baseType = ((RuleBuilder)b).baseType;
        this.color = ((RuleBuilder)b).color;
        this.comment = ((RuleBuilder)b).comment;
        this.groups = ((RuleBuilder)b).groups;
    }

    @Generated
    public static RuleBuilder<?, ?> builder() {
        return new RuleBuilderImpl();
    }

    @Generated
    public Condition getCondition() {
        return this.condition;
    }

    @Generated
    public LocalDateTime getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public LocalDateTime getActiveTo() {
        return this.activeTo;
    }

    @Generated
    public ExceptionRuleBaseType getBaseType() {
        return this.baseType;
    }

    @Generated
    public Color getColor() {
        return this.color;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public List<Group> getGroups() {
        return this.groups;
    }

    @Generated
    public Rule setCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    @Generated
    public Rule setActiveFrom(LocalDateTime activeFrom) {
        this.activeFrom = activeFrom;
        return this;
    }

    @Generated
    public Rule setActiveTo(LocalDateTime activeTo) {
        this.activeTo = activeTo;
        return this;
    }

    @Generated
    public Rule setBaseType(ExceptionRuleBaseType baseType) {
        this.baseType = baseType;
        return this;
    }

    @Generated
    public Rule setColor(Color color) {
        this.color = color;
        return this;
    }

    @Generated
    public Rule setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Generated
    public Rule setGroups(List<Group> groups) {
        this.groups = groups;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Condition this$condition = this.getCondition();
        Condition other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
            return false;
        }
        LocalDateTime this$activeFrom = this.getActiveFrom();
        LocalDateTime other$activeFrom = other.getActiveFrom();
        if (this$activeFrom == null ? other$activeFrom != null : !((Object)this$activeFrom).equals(other$activeFrom)) {
            return false;
        }
        LocalDateTime this$activeTo = this.getActiveTo();
        LocalDateTime other$activeTo = other.getActiveTo();
        if (this$activeTo == null ? other$activeTo != null : !((Object)this$activeTo).equals(other$activeTo)) {
            return false;
        }
        ExceptionRuleBaseType this$baseType = this.getBaseType();
        ExceptionRuleBaseType other$baseType = other.getBaseType();
        if (this$baseType == null ? other$baseType != null : !this$baseType.equals(other$baseType)) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<Group> this$groups = this.getGroups();
        List<Group> other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rule;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Condition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        LocalDateTime $activeFrom = this.getActiveFrom();
        result = result * 59 + ($activeFrom == null ? 43 : ((Object)$activeFrom).hashCode());
        LocalDateTime $activeTo = this.getActiveTo();
        result = result * 59 + ($activeTo == null ? 43 : ((Object)$activeTo).hashCode());
        ExceptionRuleBaseType $baseType = this.getBaseType();
        result = result * 59 + ($baseType == null ? 43 : $baseType.hashCode());
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<Group> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Rule(super=" + super.toString() + ", condition=" + this.getCondition() + ", activeFrom=" + this.getActiveFrom() + ", activeTo=" + this.getActiveTo() + ", baseType=" + this.getBaseType() + ", color=" + this.getColor() + ", comment=" + this.getComment() + ", groups=" + this.getGroups() + ")";
    }

    @Generated
    public Rule() {
    }

    @Generated
    private static final class RuleBuilderImpl
    extends RuleBuilder<Rule, RuleBuilderImpl> {
        @Generated
        private RuleBuilderImpl() {
        }

        @Override
        @Generated
        protected RuleBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Rule build() {
            return new Rule(this);
        }
    }

    @Generated
    public static abstract class RuleBuilder<C extends Rule, B extends RuleBuilder<C, B>>
    extends NameEntityWithVersion.NameEntityWithVersionBuilder<C, B> {
        @Generated
        private Condition condition;
        @Generated
        private LocalDateTime activeFrom;
        @Generated
        private LocalDateTime activeTo;
        @Generated
        private ExceptionRuleBaseType baseType;
        @Generated
        private Color color;
        @Generated
        private String comment;
        @Generated
        private List<Group> groups;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B condition(Condition condition) {
            this.condition = condition;
            return (B)this.self();
        }

        @Generated
        public B activeFrom(LocalDateTime activeFrom) {
            this.activeFrom = activeFrom;
            return (B)this.self();
        }

        @Generated
        public B activeTo(LocalDateTime activeTo) {
            this.activeTo = activeTo;
            return (B)this.self();
        }

        @Generated
        public B baseType(ExceptionRuleBaseType baseType) {
            this.baseType = baseType;
            return (B)this.self();
        }

        @Generated
        public B color(Color color) {
            this.color = color;
            return (B)this.self();
        }

        @Generated
        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        @Generated
        public B groups(List<Group> groups) {
            this.groups = groups;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Rule.RuleBuilder(super=" + super.toString() + ", condition=" + this.condition + ", activeFrom=" + this.activeFrom + ", activeTo=" + this.activeTo + ", baseType=" + this.baseType + ", color=" + this.color + ", comment=" + this.comment + ", groups=" + this.groups + ")";
        }
    }
}

