/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.textmessage;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MessageContentType implements HasName
{
    NORMAL("Normal", 0),
    CANNED_RESPONSE("CannedResponse", 1),
    LOCATION("Location", 2),
    DATA_TO_COMPONENT("DataToComponent", 3),
    STATUS_DATA_REQUEST("StatusDataRequest", 4),
    IMMOBILIZATION("Immobilization", 5),
    GO_TALK("GoTalk", 6),
    IOX_OUTPUT("IoxOutput", 7),
    BEEP("Beep", 8),
    SERIAL_IOX("SerialIox", 9),
    DRIVER_WHITE_LIST("DriverWhiteList", 10),
    MIME_CONTENT("MimeContent", 11),
    CAN("CAN", 12),
    PASSTHROUGH_ENABLED_MESSAGE("PassthroughEnabledMessage", 13),
    VEHICLE_COMMAND("VehicleCommand", 14),
    OTAU_CONTENT("OtauContent", 15),
    WORKSHOP_MODE("WorkshopMode", 16),
    FLASH_MEMORY("FlashMemory", 17),
    MIME_REFERENCE_CONTENT("MimeReferenceContent", 18);

    @Generated
    private static final Logger log;
    private final String name;
    private final int code;

    private MessageContentType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    @JsonValue
    public String getName() {
        return this.name;
    }

    public static MessageContentType findOrDefault(String name) {
        if (Util.isEmpty(name)) {
            log.warn("Empty value is not recognized for {} enum; returning default {}", (Object)MessageContentType.class.getSimpleName(), (Object)NORMAL);
            return NORMAL;
        }
        for (MessageContentType authenticationType : MessageContentType.values()) {
            if (!authenticationType.getName().equalsIgnoreCase(name.trim())) continue;
            return authenticationType;
        }
        log.warn("{} is not recognized for {} enum; returning default {}", new Object[]{name, MessageContentType.class.getSimpleName(), NORMAL});
        return NORMAL;
    }

    static {
        log = LoggerFactory.getLogger(MessageContentType.class);
    }

    private static class Constants {
        private Constants() {
        }
    }
}

