/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.certificate.Certificate;
import com.geotab.model.entity.fuel.FuelEconomyUnit;
import com.geotab.model.entity.group.Group;
import com.geotab.model.entity.user.Currency;
import com.geotab.model.entity.user.ElectricEnergyEconomyUnit;
import com.geotab.model.entity.user.HosRuleSet;
import com.geotab.model.entity.user.NoDriver;
import com.geotab.model.entity.user.NoUser;
import com.geotab.model.entity.user.SystemUser;
import com.geotab.model.entity.user.UnknownDriver;
import com.geotab.model.entity.user.UserAuthenticationType;
import com.geotab.model.entity.user.ZoneDisplayMode;
import com.geotab.model.entity.worktime.DayOfWeek;
import com.geotab.model.serialization.EntityCollectionAsIdCollectionSerializer;
import com.geotab.model.serialization.UserDeserializer;
import com.geotab.model.settings.GoogleMapStyle;
import com.geotab.model.settings.HereMapStyle;
import com.geotab.model.settings.MapView;
import com.geotab.model.settings.OpenStreetMapStyle;
import com.geotab.util.Util;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(using=UserDeserializer.class)
public class User
extends NameEntityWithVersion {
    protected Integer acceptedEULA;
    protected Integer driveGuideVersion;
    protected Integer wifiEULA;
    protected List<String> activeDashboardReports;
    protected List<String> bookmarks;
    protected LocalDateTime activeFrom;
    protected LocalDateTime activeTo;
    protected List<String> availableDashboardReports;
    protected String[][] cannedResponseOptions;
    @JsonProperty(value="changePassword")
    protected Boolean changePassword;
    protected String comment;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> companyGroups;
    protected String dateFormat;
    protected String phoneNumber;
    protected Currency displayCurrency;
    protected String countryCode;
    protected String phoneNumberExtension;
    protected GoogleMapStyle defaultGoogleMapStyle;
    protected String defaultMapEngine;
    protected OpenStreetMapStyle defaultOpenStreetMapStyle;
    protected HereMapStyle defaultHereMapStyle;
    protected String defaultPage;
    protected String designation;
    protected String employeeNo;
    protected String firstName;
    protected FuelEconomyUnit fuelEconomyUnit;
    protected ElectricEnergyEconomyUnit electricEnergyEconomyUnit;
    protected HosRuleSet hosRuleSet;
    @JsonProperty(value="isYardMoveEnabled")
    protected Boolean isYardMoveEnabled;
    @JsonProperty(value="isPersonalConveyanceEnabled")
    protected Boolean isPersonalConveyanceEnabled;
    @JsonProperty(value="isExemptHOSEnabled")
    protected Boolean isExemptHOSEnabled;
    protected Double maxPCDistancePerDay;
    protected String authorityName;
    protected String authorityAddress;
    @JsonProperty(value="isEULAAccepted")
    protected Boolean isEULAAccepted;
    @JsonProperty(value="isNewsEnabled")
    protected Boolean isNewsEnabled = true;
    @JsonProperty(value="isServiceUpdatesEnabled")
    protected Boolean isServiceUpdatesEnabled;
    @JsonProperty(value="isLabsEnabled")
    protected Boolean isLabsEnabled;
    @JsonProperty(value="isMetric")
    protected Boolean isMetric = true;
    protected String language;
    protected DayOfWeek firstDayOfWeek;
    protected String lastName;
    protected List<MapView> mapViews;
    protected String password;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> privateUserGroups;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> reportGroups;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> securityGroups;
    @JsonProperty(value="showClickOnceWarning")
    protected Boolean showClickOnceWarning;
    protected String timeZoneId;
    protected UserAuthenticationType userAuthenticationType;
    protected ZoneDisplayMode zoneDisplayMode;
    protected Certificate issuerCertificate;
    protected String companyName;
    protected String companyAddress;
    protected String carrierNumber;
    protected LocalDateTime lastAccessDate;
    @JsonProperty(value="isDriver")
    protected Boolean isDriver;
    @JsonProperty(value="isEmailReportEnabled")
    protected Boolean isEmailReportEnabled = true;

    public User(String id) {
        this.setId(new Id(id));
        this.setName(id);
    }

    public static User fromSystem(String id) {
        if (Util.isEmpty(id)) {
            return null;
        }
        if ("NoDriverId".equals(id)) {
            return NoDriver.getInstance();
        }
        if ("UnknownDriverId".equals(id)) {
            return UnknownDriver.getInstance();
        }
        if ("NoUserId".equals(id)) {
            return NoUser.getInstance();
        }
        if ("SystemUserId".equals(id)) {
            return SystemUser.getInstance();
        }
        return null;
    }

    @Generated
    protected User(UserBuilder<?, ?> b) {
        super((NameEntityWithVersion.NameEntityWithVersionBuilder<?, ?>)b);
        this.acceptedEULA = ((UserBuilder)b).acceptedEULA;
        this.driveGuideVersion = ((UserBuilder)b).driveGuideVersion;
        this.wifiEULA = ((UserBuilder)b).wifiEULA;
        this.activeDashboardReports = ((UserBuilder)b).activeDashboardReports;
        this.bookmarks = ((UserBuilder)b).bookmarks;
        this.activeFrom = ((UserBuilder)b).activeFrom;
        this.activeTo = ((UserBuilder)b).activeTo;
        this.availableDashboardReports = ((UserBuilder)b).availableDashboardReports;
        this.cannedResponseOptions = ((UserBuilder)b).cannedResponseOptions;
        this.changePassword = ((UserBuilder)b).changePassword;
        this.comment = ((UserBuilder)b).comment;
        this.companyGroups = ((UserBuilder)b).companyGroups;
        this.dateFormat = ((UserBuilder)b).dateFormat;
        this.phoneNumber = ((UserBuilder)b).phoneNumber;
        this.displayCurrency = ((UserBuilder)b).displayCurrency;
        this.countryCode = ((UserBuilder)b).countryCode;
        this.phoneNumberExtension = ((UserBuilder)b).phoneNumberExtension;
        this.defaultGoogleMapStyle = ((UserBuilder)b).defaultGoogleMapStyle;
        this.defaultMapEngine = ((UserBuilder)b).defaultMapEngine;
        this.defaultOpenStreetMapStyle = ((UserBuilder)b).defaultOpenStreetMapStyle;
        this.defaultHereMapStyle = ((UserBuilder)b).defaultHereMapStyle;
        this.defaultPage = ((UserBuilder)b).defaultPage;
        this.designation = ((UserBuilder)b).designation;
        this.employeeNo = ((UserBuilder)b).employeeNo;
        this.firstName = ((UserBuilder)b).firstName;
        this.fuelEconomyUnit = ((UserBuilder)b).fuelEconomyUnit;
        this.electricEnergyEconomyUnit = ((UserBuilder)b).electricEnergyEconomyUnit;
        this.hosRuleSet = ((UserBuilder)b).hosRuleSet;
        this.isYardMoveEnabled = ((UserBuilder)b).isYardMoveEnabled;
        this.isPersonalConveyanceEnabled = ((UserBuilder)b).isPersonalConveyanceEnabled;
        this.isExemptHOSEnabled = ((UserBuilder)b).isExemptHOSEnabled;
        this.maxPCDistancePerDay = ((UserBuilder)b).maxPCDistancePerDay;
        this.authorityName = ((UserBuilder)b).authorityName;
        this.authorityAddress = ((UserBuilder)b).authorityAddress;
        this.isEULAAccepted = ((UserBuilder)b).isEULAAccepted;
        this.isNewsEnabled = ((UserBuilder)b).isNewsEnabled;
        this.isServiceUpdatesEnabled = ((UserBuilder)b).isServiceUpdatesEnabled;
        this.isLabsEnabled = ((UserBuilder)b).isLabsEnabled;
        this.isMetric = ((UserBuilder)b).isMetric;
        this.language = ((UserBuilder)b).language;
        this.firstDayOfWeek = ((UserBuilder)b).firstDayOfWeek;
        this.lastName = ((UserBuilder)b).lastName;
        this.mapViews = ((UserBuilder)b).mapViews;
        this.password = ((UserBuilder)b).password;
        this.privateUserGroups = ((UserBuilder)b).privateUserGroups;
        this.reportGroups = ((UserBuilder)b).reportGroups;
        this.securityGroups = ((UserBuilder)b).securityGroups;
        this.showClickOnceWarning = ((UserBuilder)b).showClickOnceWarning;
        this.timeZoneId = ((UserBuilder)b).timeZoneId;
        this.userAuthenticationType = ((UserBuilder)b).userAuthenticationType;
        this.zoneDisplayMode = ((UserBuilder)b).zoneDisplayMode;
        this.issuerCertificate = ((UserBuilder)b).issuerCertificate;
        this.companyName = ((UserBuilder)b).companyName;
        this.companyAddress = ((UserBuilder)b).companyAddress;
        this.carrierNumber = ((UserBuilder)b).carrierNumber;
        this.lastAccessDate = ((UserBuilder)b).lastAccessDate;
        this.isDriver = ((UserBuilder)b).isDriver;
        this.isEmailReportEnabled = ((UserBuilder)b).isEmailReportEnabled;
    }

    @Generated
    public static UserBuilder<?, ?> userBuilder() {
        return new UserBuilderImpl();
    }

    @Generated
    public Integer getAcceptedEULA() {
        return this.acceptedEULA;
    }

    @Generated
    public Integer getDriveGuideVersion() {
        return this.driveGuideVersion;
    }

    @Generated
    public Integer getWifiEULA() {
        return this.wifiEULA;
    }

    @Generated
    public List<String> getActiveDashboardReports() {
        return this.activeDashboardReports;
    }

    @Generated
    public List<String> getBookmarks() {
        return this.bookmarks;
    }

    @Generated
    public LocalDateTime getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public LocalDateTime getActiveTo() {
        return this.activeTo;
    }

    @Generated
    public List<String> getAvailableDashboardReports() {
        return this.availableDashboardReports;
    }

    @Generated
    public String[][] getCannedResponseOptions() {
        return this.cannedResponseOptions;
    }

    @Generated
    public Boolean getChangePassword() {
        return this.changePassword;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public List<Group> getCompanyGroups() {
        return this.companyGroups;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Generated
    public Currency getDisplayCurrency() {
        return this.displayCurrency;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getPhoneNumberExtension() {
        return this.phoneNumberExtension;
    }

    @Generated
    public GoogleMapStyle getDefaultGoogleMapStyle() {
        return this.defaultGoogleMapStyle;
    }

    @Generated
    public String getDefaultMapEngine() {
        return this.defaultMapEngine;
    }

    @Generated
    public OpenStreetMapStyle getDefaultOpenStreetMapStyle() {
        return this.defaultOpenStreetMapStyle;
    }

    @Generated
    public HereMapStyle getDefaultHereMapStyle() {
        return this.defaultHereMapStyle;
    }

    @Generated
    public String getDefaultPage() {
        return this.defaultPage;
    }

    @Generated
    public String getDesignation() {
        return this.designation;
    }

    @Generated
    public String getEmployeeNo() {
        return this.employeeNo;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public FuelEconomyUnit getFuelEconomyUnit() {
        return this.fuelEconomyUnit;
    }

    @Generated
    public ElectricEnergyEconomyUnit getElectricEnergyEconomyUnit() {
        return this.electricEnergyEconomyUnit;
    }

    @Generated
    public HosRuleSet getHosRuleSet() {
        return this.hosRuleSet;
    }

    @Generated
    public Boolean getIsYardMoveEnabled() {
        return this.isYardMoveEnabled;
    }

    @Generated
    public Boolean getIsPersonalConveyanceEnabled() {
        return this.isPersonalConveyanceEnabled;
    }

    @Generated
    public Boolean getIsExemptHOSEnabled() {
        return this.isExemptHOSEnabled;
    }

    @Generated
    public Double getMaxPCDistancePerDay() {
        return this.maxPCDistancePerDay;
    }

    @Generated
    public String getAuthorityName() {
        return this.authorityName;
    }

    @Generated
    public String getAuthorityAddress() {
        return this.authorityAddress;
    }

    @Generated
    public Boolean getIsEULAAccepted() {
        return this.isEULAAccepted;
    }

    @Generated
    public Boolean getIsNewsEnabled() {
        return this.isNewsEnabled;
    }

    @Generated
    public Boolean getIsServiceUpdatesEnabled() {
        return this.isServiceUpdatesEnabled;
    }

    @Generated
    public Boolean getIsLabsEnabled() {
        return this.isLabsEnabled;
    }

    @Generated
    public Boolean getIsMetric() {
        return this.isMetric;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public List<MapView> getMapViews() {
        return this.mapViews;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public List<Group> getPrivateUserGroups() {
        return this.privateUserGroups;
    }

    @Generated
    public List<Group> getReportGroups() {
        return this.reportGroups;
    }

    @Generated
    public List<Group> getSecurityGroups() {
        return this.securityGroups;
    }

    @Generated
    public Boolean getShowClickOnceWarning() {
        return this.showClickOnceWarning;
    }

    @Generated
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Generated
    public UserAuthenticationType getUserAuthenticationType() {
        return this.userAuthenticationType;
    }

    @Generated
    public ZoneDisplayMode getZoneDisplayMode() {
        return this.zoneDisplayMode;
    }

    @Generated
    public Certificate getIssuerCertificate() {
        return this.issuerCertificate;
    }

    @Generated
    public String getCompanyName() {
        return this.companyName;
    }

    @Generated
    public String getCompanyAddress() {
        return this.companyAddress;
    }

    @Generated
    public String getCarrierNumber() {
        return this.carrierNumber;
    }

    @Generated
    public LocalDateTime getLastAccessDate() {
        return this.lastAccessDate;
    }

    @Generated
    public Boolean getIsDriver() {
        return this.isDriver;
    }

    @Generated
    public Boolean getIsEmailReportEnabled() {
        return this.isEmailReportEnabled;
    }

    @Generated
    public User setAcceptedEULA(Integer acceptedEULA) {
        this.acceptedEULA = acceptedEULA;
        return this;
    }

    @Generated
    public User setDriveGuideVersion(Integer driveGuideVersion) {
        this.driveGuideVersion = driveGuideVersion;
        return this;
    }

    @Generated
    public User setWifiEULA(Integer wifiEULA) {
        this.wifiEULA = wifiEULA;
        return this;
    }

    @Generated
    public User setActiveDashboardReports(List<String> activeDashboardReports) {
        this.activeDashboardReports = activeDashboardReports;
        return this;
    }

    @Generated
    public User setBookmarks(List<String> bookmarks) {
        this.bookmarks = bookmarks;
        return this;
    }

    @Generated
    public User setActiveFrom(LocalDateTime activeFrom) {
        this.activeFrom = activeFrom;
        return this;
    }

    @Generated
    public User setActiveTo(LocalDateTime activeTo) {
        this.activeTo = activeTo;
        return this;
    }

    @Generated
    public User setAvailableDashboardReports(List<String> availableDashboardReports) {
        this.availableDashboardReports = availableDashboardReports;
        return this;
    }

    @Generated
    public User setCannedResponseOptions(String[][] cannedResponseOptions) {
        this.cannedResponseOptions = cannedResponseOptions;
        return this;
    }

    @JsonProperty(value="changePassword")
    @Generated
    public User setChangePassword(Boolean changePassword) {
        this.changePassword = changePassword;
        return this;
    }

    @Generated
    public User setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Generated
    public User setCompanyGroups(List<Group> companyGroups) {
        this.companyGroups = companyGroups;
        return this;
    }

    @Generated
    public User setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    @Generated
    public User setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Generated
    public User setDisplayCurrency(Currency displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Generated
    public User setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Generated
    public User setPhoneNumberExtension(String phoneNumberExtension) {
        this.phoneNumberExtension = phoneNumberExtension;
        return this;
    }

    @Generated
    public User setDefaultGoogleMapStyle(GoogleMapStyle defaultGoogleMapStyle) {
        this.defaultGoogleMapStyle = defaultGoogleMapStyle;
        return this;
    }

    @Generated
    public User setDefaultMapEngine(String defaultMapEngine) {
        this.defaultMapEngine = defaultMapEngine;
        return this;
    }

    @Generated
    public User setDefaultOpenStreetMapStyle(OpenStreetMapStyle defaultOpenStreetMapStyle) {
        this.defaultOpenStreetMapStyle = defaultOpenStreetMapStyle;
        return this;
    }

    @Generated
    public User setDefaultHereMapStyle(HereMapStyle defaultHereMapStyle) {
        this.defaultHereMapStyle = defaultHereMapStyle;
        return this;
    }

    @Generated
    public User setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
        return this;
    }

    @Generated
    public User setDesignation(String designation) {
        this.designation = designation;
        return this;
    }

    @Generated
    public User setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
        return this;
    }

    @Generated
    public User setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Generated
    public User setFuelEconomyUnit(FuelEconomyUnit fuelEconomyUnit) {
        this.fuelEconomyUnit = fuelEconomyUnit;
        return this;
    }

    @Generated
    public User setElectricEnergyEconomyUnit(ElectricEnergyEconomyUnit electricEnergyEconomyUnit) {
        this.electricEnergyEconomyUnit = electricEnergyEconomyUnit;
        return this;
    }

    @Generated
    public User setHosRuleSet(HosRuleSet hosRuleSet) {
        this.hosRuleSet = hosRuleSet;
        return this;
    }

    @JsonProperty(value="isYardMoveEnabled")
    @Generated
    public User setIsYardMoveEnabled(Boolean isYardMoveEnabled) {
        this.isYardMoveEnabled = isYardMoveEnabled;
        return this;
    }

    @JsonProperty(value="isPersonalConveyanceEnabled")
    @Generated
    public User setIsPersonalConveyanceEnabled(Boolean isPersonalConveyanceEnabled) {
        this.isPersonalConveyanceEnabled = isPersonalConveyanceEnabled;
        return this;
    }

    @JsonProperty(value="isExemptHOSEnabled")
    @Generated
    public User setIsExemptHOSEnabled(Boolean isExemptHOSEnabled) {
        this.isExemptHOSEnabled = isExemptHOSEnabled;
        return this;
    }

    @Generated
    public User setMaxPCDistancePerDay(Double maxPCDistancePerDay) {
        this.maxPCDistancePerDay = maxPCDistancePerDay;
        return this;
    }

    @Generated
    public User setAuthorityName(String authorityName) {
        this.authorityName = authorityName;
        return this;
    }

    @Generated
    public User setAuthorityAddress(String authorityAddress) {
        this.authorityAddress = authorityAddress;
        return this;
    }

    @JsonProperty(value="isEULAAccepted")
    @Generated
    public User setIsEULAAccepted(Boolean isEULAAccepted) {
        this.isEULAAccepted = isEULAAccepted;
        return this;
    }

    @JsonProperty(value="isNewsEnabled")
    @Generated
    public User setIsNewsEnabled(Boolean isNewsEnabled) {
        this.isNewsEnabled = isNewsEnabled;
        return this;
    }

    @JsonProperty(value="isServiceUpdatesEnabled")
    @Generated
    public User setIsServiceUpdatesEnabled(Boolean isServiceUpdatesEnabled) {
        this.isServiceUpdatesEnabled = isServiceUpdatesEnabled;
        return this;
    }

    @JsonProperty(value="isLabsEnabled")
    @Generated
    public User setIsLabsEnabled(Boolean isLabsEnabled) {
        this.isLabsEnabled = isLabsEnabled;
        return this;
    }

    @JsonProperty(value="isMetric")
    @Generated
    public User setIsMetric(Boolean isMetric) {
        this.isMetric = isMetric;
        return this;
    }

    @Generated
    public User setLanguage(String language) {
        this.language = language;
        return this;
    }

    @Generated
    public User setFirstDayOfWeek(DayOfWeek firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    @Generated
    public User setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Generated
    public User setMapViews(List<MapView> mapViews) {
        this.mapViews = mapViews;
        return this;
    }

    @Generated
    public User setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public User setPrivateUserGroups(List<Group> privateUserGroups) {
        this.privateUserGroups = privateUserGroups;
        return this;
    }

    @Generated
    public User setReportGroups(List<Group> reportGroups) {
        this.reportGroups = reportGroups;
        return this;
    }

    @Generated
    public User setSecurityGroups(List<Group> securityGroups) {
        this.securityGroups = securityGroups;
        return this;
    }

    @JsonProperty(value="showClickOnceWarning")
    @Generated
    public User setShowClickOnceWarning(Boolean showClickOnceWarning) {
        this.showClickOnceWarning = showClickOnceWarning;
        return this;
    }

    @Generated
    public User setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    @Generated
    public User setUserAuthenticationType(UserAuthenticationType userAuthenticationType) {
        this.userAuthenticationType = userAuthenticationType;
        return this;
    }

    @Generated
    public User setZoneDisplayMode(ZoneDisplayMode zoneDisplayMode) {
        this.zoneDisplayMode = zoneDisplayMode;
        return this;
    }

    @Generated
    public User setIssuerCertificate(Certificate issuerCertificate) {
        this.issuerCertificate = issuerCertificate;
        return this;
    }

    @Generated
    public User setCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Generated
    public User setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
        return this;
    }

    @Generated
    public User setCarrierNumber(String carrierNumber) {
        this.carrierNumber = carrierNumber;
        return this;
    }

    @Generated
    public User setLastAccessDate(LocalDateTime lastAccessDate) {
        this.lastAccessDate = lastAccessDate;
        return this;
    }

    @JsonProperty(value="isDriver")
    @Generated
    public User setIsDriver(Boolean isDriver) {
        this.isDriver = isDriver;
        return this;
    }

    @JsonProperty(value="isEmailReportEnabled")
    @Generated
    public User setIsEmailReportEnabled(Boolean isEmailReportEnabled) {
        this.isEmailReportEnabled = isEmailReportEnabled;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$acceptedEULA = this.getAcceptedEULA();
        Integer other$acceptedEULA = other.getAcceptedEULA();
        if (this$acceptedEULA == null ? other$acceptedEULA != null : !((Object)this$acceptedEULA).equals(other$acceptedEULA)) {
            return false;
        }
        Integer this$driveGuideVersion = this.getDriveGuideVersion();
        Integer other$driveGuideVersion = other.getDriveGuideVersion();
        if (this$driveGuideVersion == null ? other$driveGuideVersion != null : !((Object)this$driveGuideVersion).equals(other$driveGuideVersion)) {
            return false;
        }
        Integer this$wifiEULA = this.getWifiEULA();
        Integer other$wifiEULA = other.getWifiEULA();
        if (this$wifiEULA == null ? other$wifiEULA != null : !((Object)this$wifiEULA).equals(other$wifiEULA)) {
            return false;
        }
        Boolean this$changePassword = this.getChangePassword();
        Boolean other$changePassword = other.getChangePassword();
        if (this$changePassword == null ? other$changePassword != null : !((Object)this$changePassword).equals(other$changePassword)) {
            return false;
        }
        Boolean this$isYardMoveEnabled = this.getIsYardMoveEnabled();
        Boolean other$isYardMoveEnabled = other.getIsYardMoveEnabled();
        if (this$isYardMoveEnabled == null ? other$isYardMoveEnabled != null : !((Object)this$isYardMoveEnabled).equals(other$isYardMoveEnabled)) {
            return false;
        }
        Boolean this$isPersonalConveyanceEnabled = this.getIsPersonalConveyanceEnabled();
        Boolean other$isPersonalConveyanceEnabled = other.getIsPersonalConveyanceEnabled();
        if (this$isPersonalConveyanceEnabled == null ? other$isPersonalConveyanceEnabled != null : !((Object)this$isPersonalConveyanceEnabled).equals(other$isPersonalConveyanceEnabled)) {
            return false;
        }
        Boolean this$isExemptHOSEnabled = this.getIsExemptHOSEnabled();
        Boolean other$isExemptHOSEnabled = other.getIsExemptHOSEnabled();
        if (this$isExemptHOSEnabled == null ? other$isExemptHOSEnabled != null : !((Object)this$isExemptHOSEnabled).equals(other$isExemptHOSEnabled)) {
            return false;
        }
        Double this$maxPCDistancePerDay = this.getMaxPCDistancePerDay();
        Double other$maxPCDistancePerDay = other.getMaxPCDistancePerDay();
        if (this$maxPCDistancePerDay == null ? other$maxPCDistancePerDay != null : !((Object)this$maxPCDistancePerDay).equals(other$maxPCDistancePerDay)) {
            return false;
        }
        Boolean this$isEULAAccepted = this.getIsEULAAccepted();
        Boolean other$isEULAAccepted = other.getIsEULAAccepted();
        if (this$isEULAAccepted == null ? other$isEULAAccepted != null : !((Object)this$isEULAAccepted).equals(other$isEULAAccepted)) {
            return false;
        }
        Boolean this$isNewsEnabled = this.getIsNewsEnabled();
        Boolean other$isNewsEnabled = other.getIsNewsEnabled();
        if (this$isNewsEnabled == null ? other$isNewsEnabled != null : !((Object)this$isNewsEnabled).equals(other$isNewsEnabled)) {
            return false;
        }
        Boolean this$isServiceUpdatesEnabled = this.getIsServiceUpdatesEnabled();
        Boolean other$isServiceUpdatesEnabled = other.getIsServiceUpdatesEnabled();
        if (this$isServiceUpdatesEnabled == null ? other$isServiceUpdatesEnabled != null : !((Object)this$isServiceUpdatesEnabled).equals(other$isServiceUpdatesEnabled)) {
            return false;
        }
        Boolean this$isLabsEnabled = this.getIsLabsEnabled();
        Boolean other$isLabsEnabled = other.getIsLabsEnabled();
        if (this$isLabsEnabled == null ? other$isLabsEnabled != null : !((Object)this$isLabsEnabled).equals(other$isLabsEnabled)) {
            return false;
        }
        Boolean this$isMetric = this.getIsMetric();
        Boolean other$isMetric = other.getIsMetric();
        if (this$isMetric == null ? other$isMetric != null : !((Object)this$isMetric).equals(other$isMetric)) {
            return false;
        }
        Boolean this$showClickOnceWarning = this.getShowClickOnceWarning();
        Boolean other$showClickOnceWarning = other.getShowClickOnceWarning();
        if (this$showClickOnceWarning == null ? other$showClickOnceWarning != null : !((Object)this$showClickOnceWarning).equals(other$showClickOnceWarning)) {
            return false;
        }
        Boolean this$isDriver = this.getIsDriver();
        Boolean other$isDriver = other.getIsDriver();
        if (this$isDriver == null ? other$isDriver != null : !((Object)this$isDriver).equals(other$isDriver)) {
            return false;
        }
        Boolean this$isEmailReportEnabled = this.getIsEmailReportEnabled();
        Boolean other$isEmailReportEnabled = other.getIsEmailReportEnabled();
        if (this$isEmailReportEnabled == null ? other$isEmailReportEnabled != null : !((Object)this$isEmailReportEnabled).equals(other$isEmailReportEnabled)) {
            return false;
        }
        List<String> this$activeDashboardReports = this.getActiveDashboardReports();
        List<String> other$activeDashboardReports = other.getActiveDashboardReports();
        if (this$activeDashboardReports == null ? other$activeDashboardReports != null : !((Object)this$activeDashboardReports).equals(other$activeDashboardReports)) {
            return false;
        }
        List<String> this$bookmarks = this.getBookmarks();
        List<String> other$bookmarks = other.getBookmarks();
        if (this$bookmarks == null ? other$bookmarks != null : !((Object)this$bookmarks).equals(other$bookmarks)) {
            return false;
        }
        LocalDateTime this$activeFrom = this.getActiveFrom();
        LocalDateTime other$activeFrom = other.getActiveFrom();
        if (this$activeFrom == null ? other$activeFrom != null : !((Object)this$activeFrom).equals(other$activeFrom)) {
            return false;
        }
        LocalDateTime this$activeTo = this.getActiveTo();
        LocalDateTime other$activeTo = other.getActiveTo();
        if (this$activeTo == null ? other$activeTo != null : !((Object)this$activeTo).equals(other$activeTo)) {
            return false;
        }
        List<String> this$availableDashboardReports = this.getAvailableDashboardReports();
        List<String> other$availableDashboardReports = other.getAvailableDashboardReports();
        if (this$availableDashboardReports == null ? other$availableDashboardReports != null : !((Object)this$availableDashboardReports).equals(other$availableDashboardReports)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getCannedResponseOptions(), (Object[])other.getCannedResponseOptions())) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<Group> this$companyGroups = this.getCompanyGroups();
        List<Group> other$companyGroups = other.getCompanyGroups();
        if (this$companyGroups == null ? other$companyGroups != null : !((Object)this$companyGroups).equals(other$companyGroups)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        Currency this$displayCurrency = this.getDisplayCurrency();
        Currency other$displayCurrency = other.getDisplayCurrency();
        if (this$displayCurrency == null ? other$displayCurrency != null : !this$displayCurrency.equals(other$displayCurrency)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
            return false;
        }
        String this$phoneNumberExtension = this.getPhoneNumberExtension();
        String other$phoneNumberExtension = other.getPhoneNumberExtension();
        if (this$phoneNumberExtension == null ? other$phoneNumberExtension != null : !this$phoneNumberExtension.equals(other$phoneNumberExtension)) {
            return false;
        }
        GoogleMapStyle this$defaultGoogleMapStyle = this.getDefaultGoogleMapStyle();
        GoogleMapStyle other$defaultGoogleMapStyle = other.getDefaultGoogleMapStyle();
        if (this$defaultGoogleMapStyle == null ? other$defaultGoogleMapStyle != null : !this$defaultGoogleMapStyle.equals(other$defaultGoogleMapStyle)) {
            return false;
        }
        String this$defaultMapEngine = this.getDefaultMapEngine();
        String other$defaultMapEngine = other.getDefaultMapEngine();
        if (this$defaultMapEngine == null ? other$defaultMapEngine != null : !this$defaultMapEngine.equals(other$defaultMapEngine)) {
            return false;
        }
        OpenStreetMapStyle this$defaultOpenStreetMapStyle = this.getDefaultOpenStreetMapStyle();
        OpenStreetMapStyle other$defaultOpenStreetMapStyle = other.getDefaultOpenStreetMapStyle();
        if (this$defaultOpenStreetMapStyle == null ? other$defaultOpenStreetMapStyle != null : !this$defaultOpenStreetMapStyle.equals(other$defaultOpenStreetMapStyle)) {
            return false;
        }
        HereMapStyle this$defaultHereMapStyle = this.getDefaultHereMapStyle();
        HereMapStyle other$defaultHereMapStyle = other.getDefaultHereMapStyle();
        if (this$defaultHereMapStyle == null ? other$defaultHereMapStyle != null : !this$defaultHereMapStyle.equals(other$defaultHereMapStyle)) {
            return false;
        }
        String this$defaultPage = this.getDefaultPage();
        String other$defaultPage = other.getDefaultPage();
        if (this$defaultPage == null ? other$defaultPage != null : !this$defaultPage.equals(other$defaultPage)) {
            return false;
        }
        String this$designation = this.getDesignation();
        String other$designation = other.getDesignation();
        if (this$designation == null ? other$designation != null : !this$designation.equals(other$designation)) {
            return false;
        }
        String this$employeeNo = this.getEmployeeNo();
        String other$employeeNo = other.getEmployeeNo();
        if (this$employeeNo == null ? other$employeeNo != null : !this$employeeNo.equals(other$employeeNo)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        FuelEconomyUnit this$fuelEconomyUnit = this.getFuelEconomyUnit();
        FuelEconomyUnit other$fuelEconomyUnit = other.getFuelEconomyUnit();
        if (this$fuelEconomyUnit == null ? other$fuelEconomyUnit != null : !this$fuelEconomyUnit.equals(other$fuelEconomyUnit)) {
            return false;
        }
        ElectricEnergyEconomyUnit this$electricEnergyEconomyUnit = this.getElectricEnergyEconomyUnit();
        ElectricEnergyEconomyUnit other$electricEnergyEconomyUnit = other.getElectricEnergyEconomyUnit();
        if (this$electricEnergyEconomyUnit == null ? other$electricEnergyEconomyUnit != null : !this$electricEnergyEconomyUnit.equals(other$electricEnergyEconomyUnit)) {
            return false;
        }
        HosRuleSet this$hosRuleSet = this.getHosRuleSet();
        HosRuleSet other$hosRuleSet = other.getHosRuleSet();
        if (this$hosRuleSet == null ? other$hosRuleSet != null : !this$hosRuleSet.equals(other$hosRuleSet)) {
            return false;
        }
        String this$authorityName = this.getAuthorityName();
        String other$authorityName = other.getAuthorityName();
        if (this$authorityName == null ? other$authorityName != null : !this$authorityName.equals(other$authorityName)) {
            return false;
        }
        String this$authorityAddress = this.getAuthorityAddress();
        String other$authorityAddress = other.getAuthorityAddress();
        if (this$authorityAddress == null ? other$authorityAddress != null : !this$authorityAddress.equals(other$authorityAddress)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        DayOfWeek this$firstDayOfWeek = this.getFirstDayOfWeek();
        DayOfWeek other$firstDayOfWeek = other.getFirstDayOfWeek();
        if (this$firstDayOfWeek == null ? other$firstDayOfWeek != null : !this$firstDayOfWeek.equals(other$firstDayOfWeek)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        List<MapView> this$mapViews = this.getMapViews();
        List<MapView> other$mapViews = other.getMapViews();
        if (this$mapViews == null ? other$mapViews != null : !((Object)this$mapViews).equals(other$mapViews)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        List<Group> this$privateUserGroups = this.getPrivateUserGroups();
        List<Group> other$privateUserGroups = other.getPrivateUserGroups();
        if (this$privateUserGroups == null ? other$privateUserGroups != null : !((Object)this$privateUserGroups).equals(other$privateUserGroups)) {
            return false;
        }
        List<Group> this$reportGroups = this.getReportGroups();
        List<Group> other$reportGroups = other.getReportGroups();
        if (this$reportGroups == null ? other$reportGroups != null : !((Object)this$reportGroups).equals(other$reportGroups)) {
            return false;
        }
        List<Group> this$securityGroups = this.getSecurityGroups();
        List<Group> other$securityGroups = other.getSecurityGroups();
        if (this$securityGroups == null ? other$securityGroups != null : !((Object)this$securityGroups).equals(other$securityGroups)) {
            return false;
        }
        String this$timeZoneId = this.getTimeZoneId();
        String other$timeZoneId = other.getTimeZoneId();
        if (this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId)) {
            return false;
        }
        UserAuthenticationType this$userAuthenticationType = this.getUserAuthenticationType();
        UserAuthenticationType other$userAuthenticationType = other.getUserAuthenticationType();
        if (this$userAuthenticationType == null ? other$userAuthenticationType != null : !this$userAuthenticationType.equals(other$userAuthenticationType)) {
            return false;
        }
        ZoneDisplayMode this$zoneDisplayMode = this.getZoneDisplayMode();
        ZoneDisplayMode other$zoneDisplayMode = other.getZoneDisplayMode();
        if (this$zoneDisplayMode == null ? other$zoneDisplayMode != null : !this$zoneDisplayMode.equals(other$zoneDisplayMode)) {
            return false;
        }
        Certificate this$issuerCertificate = this.getIssuerCertificate();
        Certificate other$issuerCertificate = other.getIssuerCertificate();
        if (this$issuerCertificate == null ? other$issuerCertificate != null : !((Object)this$issuerCertificate).equals(other$issuerCertificate)) {
            return false;
        }
        String this$companyName = this.getCompanyName();
        String other$companyName = other.getCompanyName();
        if (this$companyName == null ? other$companyName != null : !this$companyName.equals(other$companyName)) {
            return false;
        }
        String this$companyAddress = this.getCompanyAddress();
        String other$companyAddress = other.getCompanyAddress();
        if (this$companyAddress == null ? other$companyAddress != null : !this$companyAddress.equals(other$companyAddress)) {
            return false;
        }
        String this$carrierNumber = this.getCarrierNumber();
        String other$carrierNumber = other.getCarrierNumber();
        if (this$carrierNumber == null ? other$carrierNumber != null : !this$carrierNumber.equals(other$carrierNumber)) {
            return false;
        }
        LocalDateTime this$lastAccessDate = this.getLastAccessDate();
        LocalDateTime other$lastAccessDate = other.getLastAccessDate();
        return !(this$lastAccessDate == null ? other$lastAccessDate != null : !((Object)this$lastAccessDate).equals(other$lastAccessDate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $acceptedEULA = this.getAcceptedEULA();
        result = result * 59 + ($acceptedEULA == null ? 43 : ((Object)$acceptedEULA).hashCode());
        Integer $driveGuideVersion = this.getDriveGuideVersion();
        result = result * 59 + ($driveGuideVersion == null ? 43 : ((Object)$driveGuideVersion).hashCode());
        Integer $wifiEULA = this.getWifiEULA();
        result = result * 59 + ($wifiEULA == null ? 43 : ((Object)$wifiEULA).hashCode());
        Boolean $changePassword = this.getChangePassword();
        result = result * 59 + ($changePassword == null ? 43 : ((Object)$changePassword).hashCode());
        Boolean $isYardMoveEnabled = this.getIsYardMoveEnabled();
        result = result * 59 + ($isYardMoveEnabled == null ? 43 : ((Object)$isYardMoveEnabled).hashCode());
        Boolean $isPersonalConveyanceEnabled = this.getIsPersonalConveyanceEnabled();
        result = result * 59 + ($isPersonalConveyanceEnabled == null ? 43 : ((Object)$isPersonalConveyanceEnabled).hashCode());
        Boolean $isExemptHOSEnabled = this.getIsExemptHOSEnabled();
        result = result * 59 + ($isExemptHOSEnabled == null ? 43 : ((Object)$isExemptHOSEnabled).hashCode());
        Double $maxPCDistancePerDay = this.getMaxPCDistancePerDay();
        result = result * 59 + ($maxPCDistancePerDay == null ? 43 : ((Object)$maxPCDistancePerDay).hashCode());
        Boolean $isEULAAccepted = this.getIsEULAAccepted();
        result = result * 59 + ($isEULAAccepted == null ? 43 : ((Object)$isEULAAccepted).hashCode());
        Boolean $isNewsEnabled = this.getIsNewsEnabled();
        result = result * 59 + ($isNewsEnabled == null ? 43 : ((Object)$isNewsEnabled).hashCode());
        Boolean $isServiceUpdatesEnabled = this.getIsServiceUpdatesEnabled();
        result = result * 59 + ($isServiceUpdatesEnabled == null ? 43 : ((Object)$isServiceUpdatesEnabled).hashCode());
        Boolean $isLabsEnabled = this.getIsLabsEnabled();
        result = result * 59 + ($isLabsEnabled == null ? 43 : ((Object)$isLabsEnabled).hashCode());
        Boolean $isMetric = this.getIsMetric();
        result = result * 59 + ($isMetric == null ? 43 : ((Object)$isMetric).hashCode());
        Boolean $showClickOnceWarning = this.getShowClickOnceWarning();
        result = result * 59 + ($showClickOnceWarning == null ? 43 : ((Object)$showClickOnceWarning).hashCode());
        Boolean $isDriver = this.getIsDriver();
        result = result * 59 + ($isDriver == null ? 43 : ((Object)$isDriver).hashCode());
        Boolean $isEmailReportEnabled = this.getIsEmailReportEnabled();
        result = result * 59 + ($isEmailReportEnabled == null ? 43 : ((Object)$isEmailReportEnabled).hashCode());
        List<String> $activeDashboardReports = this.getActiveDashboardReports();
        result = result * 59 + ($activeDashboardReports == null ? 43 : ((Object)$activeDashboardReports).hashCode());
        List<String> $bookmarks = this.getBookmarks();
        result = result * 59 + ($bookmarks == null ? 43 : ((Object)$bookmarks).hashCode());
        LocalDateTime $activeFrom = this.getActiveFrom();
        result = result * 59 + ($activeFrom == null ? 43 : ((Object)$activeFrom).hashCode());
        LocalDateTime $activeTo = this.getActiveTo();
        result = result * 59 + ($activeTo == null ? 43 : ((Object)$activeTo).hashCode());
        List<String> $availableDashboardReports = this.getAvailableDashboardReports();
        result = result * 59 + ($availableDashboardReports == null ? 43 : ((Object)$availableDashboardReports).hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getCannedResponseOptions());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<Group> $companyGroups = this.getCompanyGroups();
        result = result * 59 + ($companyGroups == null ? 43 : ((Object)$companyGroups).hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        Currency $displayCurrency = this.getDisplayCurrency();
        result = result * 59 + ($displayCurrency == null ? 43 : $displayCurrency.hashCode());
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        String $phoneNumberExtension = this.getPhoneNumberExtension();
        result = result * 59 + ($phoneNumberExtension == null ? 43 : $phoneNumberExtension.hashCode());
        GoogleMapStyle $defaultGoogleMapStyle = this.getDefaultGoogleMapStyle();
        result = result * 59 + ($defaultGoogleMapStyle == null ? 43 : $defaultGoogleMapStyle.hashCode());
        String $defaultMapEngine = this.getDefaultMapEngine();
        result = result * 59 + ($defaultMapEngine == null ? 43 : $defaultMapEngine.hashCode());
        OpenStreetMapStyle $defaultOpenStreetMapStyle = this.getDefaultOpenStreetMapStyle();
        result = result * 59 + ($defaultOpenStreetMapStyle == null ? 43 : $defaultOpenStreetMapStyle.hashCode());
        HereMapStyle $defaultHereMapStyle = this.getDefaultHereMapStyle();
        result = result * 59 + ($defaultHereMapStyle == null ? 43 : $defaultHereMapStyle.hashCode());
        String $defaultPage = this.getDefaultPage();
        result = result * 59 + ($defaultPage == null ? 43 : $defaultPage.hashCode());
        String $designation = this.getDesignation();
        result = result * 59 + ($designation == null ? 43 : $designation.hashCode());
        String $employeeNo = this.getEmployeeNo();
        result = result * 59 + ($employeeNo == null ? 43 : $employeeNo.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        FuelEconomyUnit $fuelEconomyUnit = this.getFuelEconomyUnit();
        result = result * 59 + ($fuelEconomyUnit == null ? 43 : $fuelEconomyUnit.hashCode());
        ElectricEnergyEconomyUnit $electricEnergyEconomyUnit = this.getElectricEnergyEconomyUnit();
        result = result * 59 + ($electricEnergyEconomyUnit == null ? 43 : $electricEnergyEconomyUnit.hashCode());
        HosRuleSet $hosRuleSet = this.getHosRuleSet();
        result = result * 59 + ($hosRuleSet == null ? 43 : $hosRuleSet.hashCode());
        String $authorityName = this.getAuthorityName();
        result = result * 59 + ($authorityName == null ? 43 : $authorityName.hashCode());
        String $authorityAddress = this.getAuthorityAddress();
        result = result * 59 + ($authorityAddress == null ? 43 : $authorityAddress.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        DayOfWeek $firstDayOfWeek = this.getFirstDayOfWeek();
        result = result * 59 + ($firstDayOfWeek == null ? 43 : $firstDayOfWeek.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        List<MapView> $mapViews = this.getMapViews();
        result = result * 59 + ($mapViews == null ? 43 : ((Object)$mapViews).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        List<Group> $privateUserGroups = this.getPrivateUserGroups();
        result = result * 59 + ($privateUserGroups == null ? 43 : ((Object)$privateUserGroups).hashCode());
        List<Group> $reportGroups = this.getReportGroups();
        result = result * 59 + ($reportGroups == null ? 43 : ((Object)$reportGroups).hashCode());
        List<Group> $securityGroups = this.getSecurityGroups();
        result = result * 59 + ($securityGroups == null ? 43 : ((Object)$securityGroups).hashCode());
        String $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        UserAuthenticationType $userAuthenticationType = this.getUserAuthenticationType();
        result = result * 59 + ($userAuthenticationType == null ? 43 : $userAuthenticationType.hashCode());
        ZoneDisplayMode $zoneDisplayMode = this.getZoneDisplayMode();
        result = result * 59 + ($zoneDisplayMode == null ? 43 : $zoneDisplayMode.hashCode());
        Certificate $issuerCertificate = this.getIssuerCertificate();
        result = result * 59 + ($issuerCertificate == null ? 43 : ((Object)$issuerCertificate).hashCode());
        String $companyName = this.getCompanyName();
        result = result * 59 + ($companyName == null ? 43 : $companyName.hashCode());
        String $companyAddress = this.getCompanyAddress();
        result = result * 59 + ($companyAddress == null ? 43 : $companyAddress.hashCode());
        String $carrierNumber = this.getCarrierNumber();
        result = result * 59 + ($carrierNumber == null ? 43 : $carrierNumber.hashCode());
        LocalDateTime $lastAccessDate = this.getLastAccessDate();
        result = result * 59 + ($lastAccessDate == null ? 43 : ((Object)$lastAccessDate).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "User(super=" + super.toString() + ", acceptedEULA=" + this.getAcceptedEULA() + ", driveGuideVersion=" + this.getDriveGuideVersion() + ", wifiEULA=" + this.getWifiEULA() + ", activeDashboardReports=" + this.getActiveDashboardReports() + ", bookmarks=" + this.getBookmarks() + ", activeFrom=" + this.getActiveFrom() + ", activeTo=" + this.getActiveTo() + ", availableDashboardReports=" + this.getAvailableDashboardReports() + ", cannedResponseOptions=" + Arrays.deepToString((Object[])this.getCannedResponseOptions()) + ", changePassword=" + this.getChangePassword() + ", comment=" + this.getComment() + ", companyGroups=" + this.getCompanyGroups() + ", dateFormat=" + this.getDateFormat() + ", phoneNumber=" + this.getPhoneNumber() + ", displayCurrency=" + this.getDisplayCurrency() + ", countryCode=" + this.getCountryCode() + ", phoneNumberExtension=" + this.getPhoneNumberExtension() + ", defaultGoogleMapStyle=" + this.getDefaultGoogleMapStyle() + ", defaultMapEngine=" + this.getDefaultMapEngine() + ", defaultOpenStreetMapStyle=" + this.getDefaultOpenStreetMapStyle() + ", defaultHereMapStyle=" + this.getDefaultHereMapStyle() + ", defaultPage=" + this.getDefaultPage() + ", designation=" + this.getDesignation() + ", employeeNo=" + this.getEmployeeNo() + ", firstName=" + this.getFirstName() + ", fuelEconomyUnit=" + this.getFuelEconomyUnit() + ", electricEnergyEconomyUnit=" + this.getElectricEnergyEconomyUnit() + ", hosRuleSet=" + this.getHosRuleSet() + ", isYardMoveEnabled=" + this.getIsYardMoveEnabled() + ", isPersonalConveyanceEnabled=" + this.getIsPersonalConveyanceEnabled() + ", isExemptHOSEnabled=" + this.getIsExemptHOSEnabled() + ", maxPCDistancePerDay=" + this.getMaxPCDistancePerDay() + ", authorityName=" + this.getAuthorityName() + ", authorityAddress=" + this.getAuthorityAddress() + ", isEULAAccepted=" + this.getIsEULAAccepted() + ", isNewsEnabled=" + this.getIsNewsEnabled() + ", isServiceUpdatesEnabled=" + this.getIsServiceUpdatesEnabled() + ", isLabsEnabled=" + this.getIsLabsEnabled() + ", isMetric=" + this.getIsMetric() + ", language=" + this.getLanguage() + ", firstDayOfWeek=" + this.getFirstDayOfWeek() + ", lastName=" + this.getLastName() + ", mapViews=" + this.getMapViews() + ", password=" + this.getPassword() + ", privateUserGroups=" + this.getPrivateUserGroups() + ", reportGroups=" + this.getReportGroups() + ", securityGroups=" + this.getSecurityGroups() + ", showClickOnceWarning=" + this.getShowClickOnceWarning() + ", timeZoneId=" + this.getTimeZoneId() + ", userAuthenticationType=" + this.getUserAuthenticationType() + ", zoneDisplayMode=" + this.getZoneDisplayMode() + ", issuerCertificate=" + this.getIssuerCertificate() + ", companyName=" + this.getCompanyName() + ", companyAddress=" + this.getCompanyAddress() + ", carrierNumber=" + this.getCarrierNumber() + ", lastAccessDate=" + this.getLastAccessDate() + ", isDriver=" + this.getIsDriver() + ", isEmailReportEnabled=" + this.getIsEmailReportEnabled() + ")";
    }

    @Generated
    public User() {
    }

    @Generated
    private static final class UserBuilderImpl
    extends UserBuilder<User, UserBuilderImpl> {
        @Generated
        private UserBuilderImpl() {
        }

        @Override
        @Generated
        protected UserBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public User build() {
            return new User(this);
        }
    }

    @Generated
    public static abstract class UserBuilder<C extends User, B extends UserBuilder<C, B>>
    extends NameEntityWithVersion.NameEntityWithVersionBuilder<C, B> {
        @Generated
        private Integer acceptedEULA;
        @Generated
        private Integer driveGuideVersion;
        @Generated
        private Integer wifiEULA;
        @Generated
        private List<String> activeDashboardReports;
        @Generated
        private List<String> bookmarks;
        @Generated
        private LocalDateTime activeFrom;
        @Generated
        private LocalDateTime activeTo;
        @Generated
        private List<String> availableDashboardReports;
        @Generated
        private String[][] cannedResponseOptions;
        @Generated
        private Boolean changePassword;
        @Generated
        private String comment;
        @Generated
        private List<Group> companyGroups;
        @Generated
        private String dateFormat;
        @Generated
        private String phoneNumber;
        @Generated
        private Currency displayCurrency;
        @Generated
        private String countryCode;
        @Generated
        private String phoneNumberExtension;
        @Generated
        private GoogleMapStyle defaultGoogleMapStyle;
        @Generated
        private String defaultMapEngine;
        @Generated
        private OpenStreetMapStyle defaultOpenStreetMapStyle;
        @Generated
        private HereMapStyle defaultHereMapStyle;
        @Generated
        private String defaultPage;
        @Generated
        private String designation;
        @Generated
        private String employeeNo;
        @Generated
        private String firstName;
        @Generated
        private FuelEconomyUnit fuelEconomyUnit;
        @Generated
        private ElectricEnergyEconomyUnit electricEnergyEconomyUnit;
        @Generated
        private HosRuleSet hosRuleSet;
        @Generated
        private Boolean isYardMoveEnabled;
        @Generated
        private Boolean isPersonalConveyanceEnabled;
        @Generated
        private Boolean isExemptHOSEnabled;
        @Generated
        private Double maxPCDistancePerDay;
        @Generated
        private String authorityName;
        @Generated
        private String authorityAddress;
        @Generated
        private Boolean isEULAAccepted;
        @Generated
        private Boolean isNewsEnabled;
        @Generated
        private Boolean isServiceUpdatesEnabled;
        @Generated
        private Boolean isLabsEnabled;
        @Generated
        private Boolean isMetric;
        @Generated
        private String language;
        @Generated
        private DayOfWeek firstDayOfWeek;
        @Generated
        private String lastName;
        @Generated
        private List<MapView> mapViews;
        @Generated
        private String password;
        @Generated
        private List<Group> privateUserGroups;
        @Generated
        private List<Group> reportGroups;
        @Generated
        private List<Group> securityGroups;
        @Generated
        private Boolean showClickOnceWarning;
        @Generated
        private String timeZoneId;
        @Generated
        private UserAuthenticationType userAuthenticationType;
        @Generated
        private ZoneDisplayMode zoneDisplayMode;
        @Generated
        private Certificate issuerCertificate;
        @Generated
        private String companyName;
        @Generated
        private String companyAddress;
        @Generated
        private String carrierNumber;
        @Generated
        private LocalDateTime lastAccessDate;
        @Generated
        private Boolean isDriver;
        @Generated
        private Boolean isEmailReportEnabled;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B acceptedEULA(Integer acceptedEULA) {
            this.acceptedEULA = acceptedEULA;
            return (B)this.self();
        }

        @Generated
        public B driveGuideVersion(Integer driveGuideVersion) {
            this.driveGuideVersion = driveGuideVersion;
            return (B)this.self();
        }

        @Generated
        public B wifiEULA(Integer wifiEULA) {
            this.wifiEULA = wifiEULA;
            return (B)this.self();
        }

        @Generated
        public B activeDashboardReports(List<String> activeDashboardReports) {
            this.activeDashboardReports = activeDashboardReports;
            return (B)this.self();
        }

        @Generated
        public B bookmarks(List<String> bookmarks) {
            this.bookmarks = bookmarks;
            return (B)this.self();
        }

        @Generated
        public B activeFrom(LocalDateTime activeFrom) {
            this.activeFrom = activeFrom;
            return (B)this.self();
        }

        @Generated
        public B activeTo(LocalDateTime activeTo) {
            this.activeTo = activeTo;
            return (B)this.self();
        }

        @Generated
        public B availableDashboardReports(List<String> availableDashboardReports) {
            this.availableDashboardReports = availableDashboardReports;
            return (B)this.self();
        }

        @Generated
        public B cannedResponseOptions(String[][] cannedResponseOptions) {
            this.cannedResponseOptions = cannedResponseOptions;
            return (B)this.self();
        }

        @JsonProperty(value="changePassword")
        @Generated
        public B changePassword(Boolean changePassword) {
            this.changePassword = changePassword;
            return (B)this.self();
        }

        @Generated
        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        @Generated
        public B companyGroups(List<Group> companyGroups) {
            this.companyGroups = companyGroups;
            return (B)this.self();
        }

        @Generated
        public B dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return (B)this.self();
        }

        @Generated
        public B phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return (B)this.self();
        }

        @Generated
        public B displayCurrency(Currency displayCurrency) {
            this.displayCurrency = displayCurrency;
            return (B)this.self();
        }

        @Generated
        public B countryCode(String countryCode) {
            this.countryCode = countryCode;
            return (B)this.self();
        }

        @Generated
        public B phoneNumberExtension(String phoneNumberExtension) {
            this.phoneNumberExtension = phoneNumberExtension;
            return (B)this.self();
        }

        @Generated
        public B defaultGoogleMapStyle(GoogleMapStyle defaultGoogleMapStyle) {
            this.defaultGoogleMapStyle = defaultGoogleMapStyle;
            return (B)this.self();
        }

        @Generated
        public B defaultMapEngine(String defaultMapEngine) {
            this.defaultMapEngine = defaultMapEngine;
            return (B)this.self();
        }

        @Generated
        public B defaultOpenStreetMapStyle(OpenStreetMapStyle defaultOpenStreetMapStyle) {
            this.defaultOpenStreetMapStyle = defaultOpenStreetMapStyle;
            return (B)this.self();
        }

        @Generated
        public B defaultHereMapStyle(HereMapStyle defaultHereMapStyle) {
            this.defaultHereMapStyle = defaultHereMapStyle;
            return (B)this.self();
        }

        @Generated
        public B defaultPage(String defaultPage) {
            this.defaultPage = defaultPage;
            return (B)this.self();
        }

        @Generated
        public B designation(String designation) {
            this.designation = designation;
            return (B)this.self();
        }

        @Generated
        public B employeeNo(String employeeNo) {
            this.employeeNo = employeeNo;
            return (B)this.self();
        }

        @Generated
        public B firstName(String firstName) {
            this.firstName = firstName;
            return (B)this.self();
        }

        @Generated
        public B fuelEconomyUnit(FuelEconomyUnit fuelEconomyUnit) {
            this.fuelEconomyUnit = fuelEconomyUnit;
            return (B)this.self();
        }

        @Generated
        public B electricEnergyEconomyUnit(ElectricEnergyEconomyUnit electricEnergyEconomyUnit) {
            this.electricEnergyEconomyUnit = electricEnergyEconomyUnit;
            return (B)this.self();
        }

        @Generated
        public B hosRuleSet(HosRuleSet hosRuleSet) {
            this.hosRuleSet = hosRuleSet;
            return (B)this.self();
        }

        @JsonProperty(value="isYardMoveEnabled")
        @Generated
        public B isYardMoveEnabled(Boolean isYardMoveEnabled) {
            this.isYardMoveEnabled = isYardMoveEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isPersonalConveyanceEnabled")
        @Generated
        public B isPersonalConveyanceEnabled(Boolean isPersonalConveyanceEnabled) {
            this.isPersonalConveyanceEnabled = isPersonalConveyanceEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isExemptHOSEnabled")
        @Generated
        public B isExemptHOSEnabled(Boolean isExemptHOSEnabled) {
            this.isExemptHOSEnabled = isExemptHOSEnabled;
            return (B)this.self();
        }

        @Generated
        public B maxPCDistancePerDay(Double maxPCDistancePerDay) {
            this.maxPCDistancePerDay = maxPCDistancePerDay;
            return (B)this.self();
        }

        @Generated
        public B authorityName(String authorityName) {
            this.authorityName = authorityName;
            return (B)this.self();
        }

        @Generated
        public B authorityAddress(String authorityAddress) {
            this.authorityAddress = authorityAddress;
            return (B)this.self();
        }

        @JsonProperty(value="isEULAAccepted")
        @Generated
        public B isEULAAccepted(Boolean isEULAAccepted) {
            this.isEULAAccepted = isEULAAccepted;
            return (B)this.self();
        }

        @JsonProperty(value="isNewsEnabled")
        @Generated
        public B isNewsEnabled(Boolean isNewsEnabled) {
            this.isNewsEnabled = isNewsEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isServiceUpdatesEnabled")
        @Generated
        public B isServiceUpdatesEnabled(Boolean isServiceUpdatesEnabled) {
            this.isServiceUpdatesEnabled = isServiceUpdatesEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isLabsEnabled")
        @Generated
        public B isLabsEnabled(Boolean isLabsEnabled) {
            this.isLabsEnabled = isLabsEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isMetric")
        @Generated
        public B isMetric(Boolean isMetric) {
            this.isMetric = isMetric;
            return (B)this.self();
        }

        @Generated
        public B language(String language) {
            this.language = language;
            return (B)this.self();
        }

        @Generated
        public B firstDayOfWeek(DayOfWeek firstDayOfWeek) {
            this.firstDayOfWeek = firstDayOfWeek;
            return (B)this.self();
        }

        @Generated
        public B lastName(String lastName) {
            this.lastName = lastName;
            return (B)this.self();
        }

        @Generated
        public B mapViews(List<MapView> mapViews) {
            this.mapViews = mapViews;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B privateUserGroups(List<Group> privateUserGroups) {
            this.privateUserGroups = privateUserGroups;
            return (B)this.self();
        }

        @Generated
        public B reportGroups(List<Group> reportGroups) {
            this.reportGroups = reportGroups;
            return (B)this.self();
        }

        @Generated
        public B securityGroups(List<Group> securityGroups) {
            this.securityGroups = securityGroups;
            return (B)this.self();
        }

        @JsonProperty(value="showClickOnceWarning")
        @Generated
        public B showClickOnceWarning(Boolean showClickOnceWarning) {
            this.showClickOnceWarning = showClickOnceWarning;
            return (B)this.self();
        }

        @Generated
        public B timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)this.self();
        }

        @Generated
        public B userAuthenticationType(UserAuthenticationType userAuthenticationType) {
            this.userAuthenticationType = userAuthenticationType;
            return (B)this.self();
        }

        @Generated
        public B zoneDisplayMode(ZoneDisplayMode zoneDisplayMode) {
            this.zoneDisplayMode = zoneDisplayMode;
            return (B)this.self();
        }

        @Generated
        public B issuerCertificate(Certificate issuerCertificate) {
            this.issuerCertificate = issuerCertificate;
            return (B)this.self();
        }

        @Generated
        public B companyName(String companyName) {
            this.companyName = companyName;
            return (B)this.self();
        }

        @Generated
        public B companyAddress(String companyAddress) {
            this.companyAddress = companyAddress;
            return (B)this.self();
        }

        @Generated
        public B carrierNumber(String carrierNumber) {
            this.carrierNumber = carrierNumber;
            return (B)this.self();
        }

        @Generated
        public B lastAccessDate(LocalDateTime lastAccessDate) {
            this.lastAccessDate = lastAccessDate;
            return (B)this.self();
        }

        @JsonProperty(value="isDriver")
        @Generated
        public B isDriver(Boolean isDriver) {
            this.isDriver = isDriver;
            return (B)this.self();
        }

        @JsonProperty(value="isEmailReportEnabled")
        @Generated
        public B isEmailReportEnabled(Boolean isEmailReportEnabled) {
            this.isEmailReportEnabled = isEmailReportEnabled;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "User.UserBuilder(super=" + super.toString() + ", acceptedEULA=" + this.acceptedEULA + ", driveGuideVersion=" + this.driveGuideVersion + ", wifiEULA=" + this.wifiEULA + ", activeDashboardReports=" + this.activeDashboardReports + ", bookmarks=" + this.bookmarks + ", activeFrom=" + this.activeFrom + ", activeTo=" + this.activeTo + ", availableDashboardReports=" + this.availableDashboardReports + ", cannedResponseOptions=" + Arrays.deepToString((Object[])this.cannedResponseOptions) + ", changePassword=" + this.changePassword + ", comment=" + this.comment + ", companyGroups=" + this.companyGroups + ", dateFormat=" + this.dateFormat + ", phoneNumber=" + this.phoneNumber + ", displayCurrency=" + this.displayCurrency + ", countryCode=" + this.countryCode + ", phoneNumberExtension=" + this.phoneNumberExtension + ", defaultGoogleMapStyle=" + this.defaultGoogleMapStyle + ", defaultMapEngine=" + this.defaultMapEngine + ", defaultOpenStreetMapStyle=" + this.defaultOpenStreetMapStyle + ", defaultHereMapStyle=" + this.defaultHereMapStyle + ", defaultPage=" + this.defaultPage + ", designation=" + this.designation + ", employeeNo=" + this.employeeNo + ", firstName=" + this.firstName + ", fuelEconomyUnit=" + this.fuelEconomyUnit + ", electricEnergyEconomyUnit=" + this.electricEnergyEconomyUnit + ", hosRuleSet=" + this.hosRuleSet + ", isYardMoveEnabled=" + this.isYardMoveEnabled + ", isPersonalConveyanceEnabled=" + this.isPersonalConveyanceEnabled + ", isExemptHOSEnabled=" + this.isExemptHOSEnabled + ", maxPCDistancePerDay=" + this.maxPCDistancePerDay + ", authorityName=" + this.authorityName + ", authorityAddress=" + this.authorityAddress + ", isEULAAccepted=" + this.isEULAAccepted + ", isNewsEnabled=" + this.isNewsEnabled + ", isServiceUpdatesEnabled=" + this.isServiceUpdatesEnabled + ", isLabsEnabled=" + this.isLabsEnabled + ", isMetric=" + this.isMetric + ", language=" + this.language + ", firstDayOfWeek=" + this.firstDayOfWeek + ", lastName=" + this.lastName + ", mapViews=" + this.mapViews + ", password=" + this.password + ", privateUserGroups=" + this.privateUserGroups + ", reportGroups=" + this.reportGroups + ", securityGroups=" + this.securityGroups + ", showClickOnceWarning=" + this.showClickOnceWarning + ", timeZoneId=" + this.timeZoneId + ", userAuthenticationType=" + this.userAuthenticationType + ", zoneDisplayMode=" + this.zoneDisplayMode + ", issuerCertificate=" + this.issuerCertificate + ", companyName=" + this.companyName + ", companyAddress=" + this.companyAddress + ", carrierNumber=" + this.carrierNumber + ", lastAccessDate=" + this.lastAccessDate + ", isDriver=" + this.isDriver + ", isEmailReportEnabled=" + this.isEmailReportEnabled + ")";
        }
    }
}

