/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum UserAuthenticationType implements HasName
{
    NONE("None", 0),
    BASIC_AUTHENTICATION("BasicAuthentication", 1),
    WINDOWS_AUTHENTICATION("WindowsAuthentication", 2),
    MY_ADMIN("MyAdmin", 4),
    SAML("SAML", 8),
    CLIENT_CERTIFICATE("ClientCertificate", 16);

    @Generated
    private static final Logger log;
    private final String name;
    private final int code;

    private UserAuthenticationType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    @JsonValue
    public String getName() {
        return this.name;
    }

    public static UserAuthenticationType findOrDefault(String name) {
        if (Util.isEmpty(name)) {
            log.warn("Empty value is not recognized for {} enum; returning default {}", (Object)UserAuthenticationType.class.getSimpleName(), (Object)NONE);
            return NONE;
        }
        for (UserAuthenticationType authenticationType : UserAuthenticationType.values()) {
            if (!authenticationType.getName().equalsIgnoreCase(name.trim())) continue;
            return authenticationType;
        }
        log.warn("{} is not recognized for {} enum; returning default {}", new Object[]{name, UserAuthenticationType.class.getSimpleName(), NONE});
        return NONE;
    }

    static {
        log = LoggerFactory.getLogger(UserAuthenticationType.class);
    }
}

