/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.login;

import com.geotab.http.request.param.Parameters;
import com.geotab.util.Util;
import com.geotab.util.UtilityValidator;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class Credentials
extends Parameters {
    private String userName;
    private String password;
    private String database = "";
    private String sessionId;

    public Credentials(String userName, String password, String database, String sessionId) {
        if (password == null && sessionId == null) {
            throw new IllegalArgumentException("Must provide either password or session ID");
        }
        this.database = UtilityValidator.createDatabaseNameFromCompany(Optional.ofNullable(database).orElse(""));
        this.userName = userName;
        this.password = password;
        this.sessionId = sessionId;
    }

    public void setPassword(String password) {
        this.password = password;
        this.sessionId = null;
    }

    public void validate() {
        if (Util.isEmpty(this.userName)) {
            throw new IllegalArgumentException("Invalid user name");
        }
        if (Util.isEmpty(this.password) && Util.isEmpty(this.sessionId)) {
            throw new IllegalArgumentException("Must supply either password or sessionId");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Credentials that = (Credentials)other;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.database, that.database) && Objects.equals(this.sessionId, that.sessionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.userName, this.database, this.sessionId);
    }

    @Override
    public String toString() {
        return this.userName + "@" + this.database;
    }

    @Generated
    protected Credentials(CredentialsBuilder<?, ?> b) {
        super(b);
        this.userName = ((CredentialsBuilder)b).userName;
        this.password = ((CredentialsBuilder)b).password;
        this.database = ((CredentialsBuilder)b).database;
        this.sessionId = ((CredentialsBuilder)b).sessionId;
    }

    @Generated
    public static CredentialsBuilder<?, ?> builder() {
        return new CredentialsBuilderImpl();
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public Credentials setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Generated
    public Credentials setDatabase(String database) {
        this.database = database;
        return this;
    }

    @Generated
    public Credentials setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Generated
    public Credentials() {
    }

    @Generated
    private static final class CredentialsBuilderImpl
    extends CredentialsBuilder<Credentials, CredentialsBuilderImpl> {
        @Generated
        private CredentialsBuilderImpl() {
        }

        @Override
        @Generated
        protected CredentialsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Credentials build() {
            return new Credentials(this);
        }
    }

    @Generated
    public static abstract class CredentialsBuilder<C extends Credentials, B extends CredentialsBuilder<C, B>>
    extends Parameters.ParametersBuilder<C, B> {
        @Generated
        private String userName;
        @Generated
        private String password;
        @Generated
        private String database;
        @Generated
        private String sessionId;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B userName(String userName) {
            this.userName = userName;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B database(String database) {
            this.database = database;
            return (B)this.self();
        }

        @Generated
        public B sessionId(String sessionId) {
            this.sessionId = sessionId;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Credentials.CredentialsBuilder(super=" + super.toString() + ", userName=" + this.userName + ", password=" + this.password + ", database=" + this.database + ", sessionId=" + this.sessionId + ")";
        }
    }
}

