/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.controller.Controller;
import com.geotab.model.entity.enginetype.EngineType;
import com.geotab.model.entity.exceptionevent.ExceptionEvent;
import com.geotab.model.entity.exceptionevent.state.ExceptionEventState;
import com.geotab.model.entity.failuremode.FailureMode;
import com.geotab.model.entity.faultdata.FaultStatus;
import com.geotab.model.entity.notification.NotificationBinaryFile;
import com.geotab.model.entity.parametergroup.ParameterGroup;
import com.geotab.model.entity.recipient.Recipient;
import com.geotab.model.entity.rule.Rule;
import com.geotab.model.entity.source.Source;
import com.geotab.model.entity.unitofmeasure.UnitOfMeasure;
import com.geotab.model.entity.worktime.WorkTime;
import com.geotab.model.entity.zone.Zone;
import com.geotab.model.entity.zone.type.ZoneType;
import com.geotab.model.serialization.ApiCustomDeserializerModifier;
import com.geotab.model.serialization.ApiCustomSerializerModifier;
import com.geotab.model.serialization.DoubleArraySerializer;
import com.geotab.model.serialization.DoublePrimitiveArraySerializer;
import com.geotab.model.serialization.DoubleSerializer;
import com.geotab.model.serialization.DurationDeserializer;
import com.geotab.model.serialization.DurationSerializer;
import com.geotab.model.serialization.FloatArraySerializer;
import com.geotab.model.serialization.FloatPrimitiveArraySerializer;
import com.geotab.model.serialization.FloatSerializer;
import com.geotab.model.serialization.LocalDateTimeDeserializer;
import com.geotab.model.serialization.LocalDateTimeSerializer;
import com.geotab.model.serialization.LongDeserializer;
import com.geotab.model.serialization.LongSerializer;
import com.geotab.model.serialization.filter.FaultDataFilterProvider;
import com.geotab.util.Util;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;

public final class ApiJsonSerializer {
    private ObjectMapper objectMapper = this.buildDefaultObjectMapper();

    private ApiJsonSerializer() {
    }

    public static ApiJsonSerializer getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public ObjectMapper buildDefaultObjectMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new DeserializationFeature[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule((Module)new JavaTimeModule())).addModule((Module)new SimpleModule("api-long-serialization-module").addSerializer(Long.TYPE, (JsonSerializer)new LongSerializer()).addSerializer(Long.class, (JsonSerializer)new LongSerializer()).addDeserializer(Long.TYPE, (JsonDeserializer)new LongDeserializer()).addDeserializer(Long.class, (JsonDeserializer)new LongDeserializer()))).addModule((Module)new SimpleModule("api-double-serialization-module").addSerializer(Double.TYPE, (JsonSerializer)new DoubleSerializer()).addSerializer(Double.class, (JsonSerializer)new DoubleSerializer()).addSerializer(double[].class, (JsonSerializer)new DoublePrimitiveArraySerializer()).addSerializer(Double[].class, (JsonSerializer)new DoubleArraySerializer()))).addModule((Module)new SimpleModule("api-float-serialization-module").addSerializer(Float.TYPE, (JsonSerializer)new FloatSerializer()).addSerializer(Float.class, (JsonSerializer)new FloatSerializer()).addSerializer(float[].class, (JsonSerializer)new FloatPrimitiveArraySerializer()).addSerializer(Float[].class, (JsonSerializer)new FloatArraySerializer()))).addModule((Module)new SimpleModule("api-time-serialization-module").addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer()).addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer()).addSerializer(Duration.class, (JsonSerializer)new DurationSerializer()).addDeserializer(Duration.class, (JsonDeserializer)new DurationDeserializer()))).addModule((Module)new SimpleModule("api-custom-serialization-module").setSerializerModifier((BeanSerializerModifier)new ApiCustomSerializerModifier()).setDeserializerModifier((BeanDeserializerModifier)new ApiCustomDeserializerModifier()))).addModule((Module)new SimpleModule("api-system-deserializers-module").setDeserializerModifier((BeanDeserializerModifier)new MyBeanDeserializerModifier()))).filterProvider((FilterProvider)new SimpleFilterProvider().addFilter("FAULT_DATA_FILTER", (SimpleBeanPropertyFilter)new FaultDataFilterProvider()))).build();
    }

    public void withCustomObjectMapper(ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new IllegalArgumentException("ObjectMapper can not be null !");
        }
        this.objectMapper = objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    static <T extends Number> void serializeNumberWithDecimals(T number, JsonGenerator jg) throws IOException {
        BigDecimal i = BigDecimal.valueOf(number.doubleValue()).stripTrailingZeros();
        if (i.signum() == 0 || i.scale() <= 0 || i.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) {
            jg.writeNumber(i.longValue());
        } else if (number instanceof Float) {
            jg.writeNumber(i.floatValue());
        } else {
            jg.writeNumber(i.doubleValue());
        }
    }

    static SystemDeserializer sys(JsonDeserializer<?> deserializer, Util.FailableFunction<String, Entity, IOException> system, Util.FailableFunction<String, Entity, IOException> builder) {
        return new SystemDeserializer(deserializer, system, builder);
    }

    static class SystemDeserializer
    extends JsonDeserializer<Entity>
    implements ResolvableDeserializer {
        final JsonDeserializer<?> deserializer;
        final Util.FailableFunction<String, Entity, IOException> entity;
        final Util.FailableFunction<String, Entity, IOException> system;

        private SystemDeserializer(JsonDeserializer<?> deserializer, Util.FailableFunction<String, Entity, IOException> system, Util.FailableFunction<String, Entity, IOException> entity) {
            this.deserializer = deserializer;
            this.system = system;
            this.entity = entity;
        }

        public Entity deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Entity entity;
            if (jsonParser.currentToken() == JsonToken.VALUE_NULL) {
                return null;
            }
            if (jsonParser.currentToken() == JsonToken.VALUE_STRING) {
                String text = jsonParser.getText();
                if (Util.isEmpty(text)) {
                    return null;
                }
                entity = this.entity.apply(text);
            } else {
                entity = (Entity)this.deserializer.deserialize(jsonParser, context);
            }
            String id = Optional.ofNullable(entity).map(Entity::getId).map(Id::getId).orElse(null);
            Entity systemEntity = Util.isEmpty(id) ? null : this.system.apply(id);
            return systemEntity != null ? systemEntity : entity;
        }

        public void resolve(DeserializationContext ctxt) throws JsonMappingException {
            ((ResolvableDeserializer)this.deserializer).resolve(ctxt);
        }
    }

    static class MyBeanDeserializerModifier
    extends BeanDeserializerModifier {
        MyBeanDeserializerModifier() {
        }

        public JsonDeserializer<?> modifyDeserializer(DeserializationConfig c, BeanDescription b, JsonDeserializer<?> d) {
            Class t = b.getBeanClass();
            if (Recipient.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, Recipient::fromSystem, id -> ((Recipient.RecipientBuilder)Recipient.builder().id((String)id)).build());
            }
            if (Controller.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, Controller::fromSystem, id -> ((Controller.ControllerBuilder)Controller.builder().id((String)id)).build());
            }
            if (Rule.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, Rule::fromSystem, Rule::new);
            }
            if (Source.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, Source::fromSystem, Source::new);
            }
            if (EngineType.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, EngineType::fromSystem, id -> ((EngineType.EngineTypeBuilder)EngineType.builder().id((String)id)).build());
            }
            if (ExceptionEvent.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, ExceptionEvent::fromSystem, id -> ((ExceptionEvent.ExceptionEventBuilder)ExceptionEvent.builder().id((String)id)).build());
            }
            if (ExceptionEventState.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, ExceptionEventState::fromSystem, id -> ((ExceptionEventState.ExceptionEventStateBuilder)ExceptionEventState.builder().id((String)id)).build());
            }
            if (FailureMode.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, FailureMode::fromSystem, id -> ((FailureMode.FailureModeBuilder)FailureMode.builder().id((String)id)).build());
            }
            if (FaultStatus.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, FaultStatus::fromSystem, FaultStatus::new);
            }
            if (NotificationBinaryFile.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, NotificationBinaryFile::fromSystem, NotificationBinaryFile::new);
            }
            if (ParameterGroup.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, ParameterGroup::fromSystem, ParameterGroup::new);
            }
            if (ZoneType.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, ZoneType::fromSystem, ZoneType::new);
            }
            if (Zone.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, Zone::fromSystem, Zone::new);
            }
            if (WorkTime.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, WorkTime::fromSystem, WorkTime::new);
            }
            if (UnitOfMeasure.class.isAssignableFrom(t)) {
                return ApiJsonSerializer.sys(d, UnitOfMeasure::fromSystem, UnitOfMeasure::new);
            }
            return super.modifyDeserializer(c, b, d);
        }
    }

    private static class InstanceHolder {
        private static final ApiJsonSerializer INSTANCE = new ApiJsonSerializer();

        private InstanceHolder() {
        }
    }
}

