/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.device.A1;
import com.geotab.model.entity.device.CustomDevice;
import com.geotab.model.entity.device.CustomVehicleDevice;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.device.DeviceType;
import com.geotab.model.entity.device.Go10;
import com.geotab.model.entity.device.Go4v3;
import com.geotab.model.entity.device.Go5;
import com.geotab.model.entity.device.Go6;
import com.geotab.model.entity.device.Go7;
import com.geotab.model.entity.device.Go8;
import com.geotab.model.entity.device.Go9;
import com.geotab.model.entity.device.Go9b;
import com.geotab.model.entity.device.GoDriveDevice;
import com.geotab.model.entity.device.GoLegacy;
import com.geotab.model.entity.device.NoDevice;
import com.geotab.model.entity.device.UntrackedAsset;
import com.geotab.model.serialization.ApiCustomDeserializerModifier;
import com.geotab.util.Util;
import java.io.IOException;

public class DeviceDeserializer
extends JsonDeserializer<Device> {
    private static final String DEVICE_TYPE_ATTRIBUTE_NAME = "deviceType";
    private static final String SERIAL_NUMBER_ATTRIBUTE_NAME = "serialNumber";
    private static final String PRODUCT_ID_ATTRIBUTE_NAME = "productId";

    public Device deserialize(JsonParser jp, DeserializationContext c) throws IOException {
        ObjectCodec parserCodec = jp.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jp);
        if (node.isTextual()) {
            return NoDevice.getInstance();
        }
        return this.hasDeviceType(node) ? this.byDeviceType(parserCodec, c, node) : this.bySerialNumberAndProductId(parserCodec, c, node);
    }

    private boolean hasDeviceType(JsonNode node) {
        return node.get(DEVICE_TYPE_ATTRIBUTE_NAME) != null && !node.get(DEVICE_TYPE_ATTRIBUTE_NAME).isNull() && DeviceType.findByName(node.get(DEVICE_TYPE_ATTRIBUTE_NAME).textValue()) != null;
    }

    private Device byDeviceType(ObjectCodec pc, DeserializationContext c, JsonNode n) throws IOException {
        switch (n.get(DEVICE_TYPE_ATTRIBUTE_NAME).asText()) {
            case "OldGeotab": 
            case "GO2": 
            case "GO3": 
            case "GO4": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, GoLegacy.class);
            }
            case "GO4v3": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, Go4v3.class);
            }
            case "GO5": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, Go5.class);
            }
            case "GO6": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, Go6.class);
            }
            case "GO7": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, Go7.class);
            }
            case "GO8": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, Go8.class);
            }
            case "GO9": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, Go9.class);
            }
            case "GO9B": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, Go9b.class);
            }
            case "GO10": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, Go10.class);
            }
            case "GoDriveDevice": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, GoDriveDevice.class);
            }
            case "CustomDevice": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, CustomDevice.class);
            }
            case "CustomVehicleDevice": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, CustomVehicleDevice.class);
            }
            case "A1": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, A1.class);
            }
            case "None": {
                return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, UntrackedAsset.class);
            }
        }
        return ApiCustomDeserializerModifier.defaultDeserialize(pc, c, n, Device.class);
    }

    private Device bySerialNumberAndProductId(ObjectCodec oc, DeserializationContext c, JsonNode n) throws IOException {
        if (n.get(SERIAL_NUMBER_ATTRIBUTE_NAME) == null || n.get(SERIAL_NUMBER_ATTRIBUTE_NAME).isNull() || !n.get(SERIAL_NUMBER_ATTRIBUTE_NAME).isTextual()) {
            return ApiCustomDeserializerModifier.defaultDeserialize(oc, c, n, Device.class);
        }
        String serialNumber = n.get(SERIAL_NUMBER_ATTRIBUTE_NAME).asText();
        int productId = Util.isEmpty(serialNumber) ? -1 : ("000-000-0000".equals(serialNumber) && n.get(PRODUCT_ID_ATTRIBUTE_NAME) != null && !n.get(PRODUCT_ID_ATTRIBUTE_NAME).isNull() ? n.get(PRODUCT_ID_ATTRIBUTE_NAME).asInt() : Device.productIdFromSerialNumber(serialNumber));
        DeviceType deviceType = Device.deviceTypeFromProductId(productId);
        Device device = ApiCustomDeserializerModifier.defaultDeserialize(oc, c, n, deviceType.getType());
        if (device != null && device.getProductId() == null) {
            device.setProductId(productId);
        }
        return device;
    }
}

