/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.ApiCustomDeserializerModifier;
import java.io.IOException;

public class DriverFromIdDeserializer
extends JsonDeserializer<Driver> {
    public Driver deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectCodec parserCodec = jsonParser.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jsonParser);
        if (node.isTextual()) {
            return (Driver)User.fromSystem(node.textValue());
        }
        if (node.isObject()) {
            Driver driver = (Driver)User.fromSystem(node.get("id").asText());
            if (driver != null) {
                return driver;
            }
            return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, Driver.class);
        }
        return null;
    }
}

