/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.ApiCustomDeserializerModifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;

public class UserDeserializer
extends JsonDeserializer<User> {
    public User deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectCodec parserCodec = jsonParser.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jsonParser);
        if (node.isTextual()) {
            return User.fromSystem(node.asText());
        }
        User system = User.fromSystem(Optional.ofNullable(node.get("id")).map(JsonNode::textValue).orElse(""));
        if (system != null) {
            return system;
        }
        Class userType = this.isDriver(node, parserCodec) ? Driver.class : User.class;
        return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, userType);
    }

    private boolean isDriver(JsonNode node, ObjectCodec parserCodec) throws JsonProcessingException {
        if (node.get("isDriver") != null && node.get("isDriver").asBoolean()) {
            return true;
        }
        return parserCodec.treeToValue((TreeNode)node.get("driverGroups"), ArrayList.class) != null;
    }
}

