/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.http.exception;

/**
 * This exception occurs if the system makes a database request that could not succeed because of connection failure or
 * data change.
 */
public class DbUnavailableException extends JsonRpcErrorDataException {

  private DbUnavailableState state;

  public DbUnavailableException(String message, Throwable cause, DbUnavailableState state) {
    super(message, cause);
    this.state = state;
  }

  public DbUnavailableState getState() {
    return this.state;
  }
}
