/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.http.exception;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum DbUnavailableState implements HasName {

  /**
   * The none.
   */
  @JsonEnumDefaultValue
  NONE("None", 0),

  /**
   * The database server connection failure (for any reason).
   */
  CONNECTION_FAILURE("ConnectionFailure", 1),

  /**
   * The unknown database.
   */
  UNKNOWN_DATABASE("UnknownDatabase", 2),

  /**
   * The database  is being initialized.
   */
  INITIALIZING("Initializing", 3),

  /**
   * The database operation aborted (for any reason: Timeout, inconsistent transaction, concurrency, cache busy, etc.
   */
  OPERATION_ABORTED("OperationAborted", 4);

  private final String name;
  private final int code;

  DbUnavailableState(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static DbUnavailableState findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          DbUnavailableState.class.getSimpleName(), DbUnavailableState.NONE);
      return NONE;
    }

    for (DbUnavailableState dbUnavailableState : values()) {
      if (dbUnavailableState.getName().equalsIgnoreCase(name.trim())) {
        return dbUnavailableState;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, DbUnavailableState.class.getSimpleName(), DbUnavailableState.NONE);
    return NONE;
  }
}
