/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.http.exception;

public enum InvalidUserType {

  /**
   * Incorrect login credentials.
   */
  DEFAULT(0, "Incorrect login credentials"),

  /**
   * User session is expired.
   */
  SESSION_EXPIRED(1, "Session expired"),

  /**
   * User is locked out.
   */
  USER_LOCKOUT(2, "User is locked out due to too many failed attempts"),

  /**
   * User session is invalid.
   */
  SESSION_INVALID(3, "Invalid session");

  private final int code;
  private final String description;

  InvalidUserType(int code, String description) {
    this.code = code;
    this.description = description;
  }

  public int getCode() {
    return code;
  }

  public String getDescription() {
    return description;
  }
}
