/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.http.exception;

import com.geotab.util.Util;
import lombok.Getter;

/**
 * Invoker exceptions where status is not 200.
 */
public class ResponseFailException extends RuntimeException {

  @Getter
  private int httpStatusCode;
  @Getter
  private String url;

  /**
   * Initializes a new instance.
   *
   * @param httpStatusCode The url.
   * @param resultAsString The result to string.
   * @param innerException The inner exception.
   */
  public ResponseFailException(int httpStatusCode, String resultAsString,
      Exception innerException) {
    this(null, httpStatusCode, resultAsString, innerException);
  }

  /**
   * Initializes a new instance.
   *
   * @param url            The url.
   * @param httpStatusCode The status code.
   * @param resultAsString The result to string.
   * @param innerException The inner exception.
   */
  public ResponseFailException(String url, int httpStatusCode, String resultAsString,
      Exception innerException) {
    super(resultAsString, innerException);
    this.httpStatusCode = httpStatusCode;
    this.url = url;
  }

  @Override
  public String getMessage() {
    String message = String.format("StatusCode: %d; %s", httpStatusCode, super.getMessage());
    if (Util.isEmpty(url)) {
      return message;
    }
    return String.format("Url: %s; %s'", url, message);
  }
}
