/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.http.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geotab.http.request.param.EmptyParameters;
import com.geotab.http.request.param.Parameters;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Data;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder(builderMethodName = "requestBuilder")
public class BaseRequest<T extends Parameters> {

  private static final Parameters EMPTY_PARAMETERS = new EmptyParameters();

  protected Integer id;

  protected String method;

  protected T params;

  /**
   * Custom Http Headers to be set on request.
   *
   * <p>Note that the http client can fail if you try to provide some default http headers (e.g. Content-Length).
   */
  @JsonIgnore
  protected Map<String, Object> httpHeaders;

  public BaseRequest() {
    //noinspection unchecked
    this(null, null, (T) EMPTY_PARAMETERS, null);
  }

  public BaseRequest(Integer id, String method, T params) {
    this(id, method, params, null);
  }

  public BaseRequest(Integer id, String method, T params, Map<String, Object> httpHeaders) {
    this.id = id;
    this.method = method;
    //noinspection unchecked
    this.params = Optional.ofNullable(params).orElse((T) EMPTY_PARAMETERS);
    this.httpHeaders = Optional.ofNullable(httpHeaders).orElse(new HashMap<>());
  }
}
