package com.geotab.http.request.param;

import com.geotab.model.search.Search;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is the primary method used to sync data from the MyGeotab system for example all the GPS positions.
 *
 * <p>Is designed to allow incremental updates by returning a FeedResult which contains the last
 * version from the set of data returned. This return version is then used as the fromVersion argument for the next
 * call. This guarantees that no changes in the data can be missed and that all data is consistently returned. It is
 * important to understand that this feed call only returns changes in the data; so that at least one change must be
 * received, otherwise the state is considered unknown. This call would typically be made every minute or more, to keep
 * the data near real-time and up to date. Provide search parameters to limit the scope of the data being returned. In
 * some rare circumstances old data in the system can be modified. If this happens, that old data is resent (with the
 * changes) as it will have a newer version. In your design you must consider this.
 *
 * <p>It may be required to provide an entity search using from date to "back-fill" or "seed" data
 * from a date in the past. Providing a from date guarantees that the feed will start at a version with all entities
 * that have a date greater than or equal to the date provided. However, it is possible that the feed will return
 * entities before the provided date. Searching using from date should be used independent of fromVersion and only on
 * the first request.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "getFeedParamsBuilder")
public class GetFeedParameters<T extends Search> extends SearchParameters<T> {

  private String fromVersion;
}
