package com.geotab.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Data;

public class Dictionary<K, V> extends ArrayList<Dictionary.Entry<K, V>> {

  public Map<K, V> asMap() {
    return stream().collect(Collectors.toMap(e -> e.k, e -> e.v));
  }

  @Data
  @SuppressWarnings("CheckStyle")
  public static class Entry<K, V> {
    protected K k;
    protected V v;
  }
}
