/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model;

import static com.geotab.util.Util.listOf;

import com.geotab.model.entity.Entity;
import java.util.List;
import java.util.Optional;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class FeedResult<T extends Entity> {

  /**
   * A list of data returned by the feed.
   */
  private List<T> data;

  /**
   * The last version of the data returned by the feed call. If this parameter is passed back into the feed call, then
   * returned data will be the changes that occurred after the last feed call was made. In this way the feed can return
   * a continuous stream of data.
   */
  private String toVersion;

  @Builder
  public FeedResult(List<T> data, String toVersion) {
    this.data = Optional.ofNullable(data).orElse(listOf());
    this.toVersion = toVersion;
  }
}
