/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.model.entity.group.SecurityIdentifier;
import com.geotab.model.entity.security.SecurityId;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Represents an item that either Adds or Removes a particular {@link SecurityIdentifier} to a user's set of allowed
 * items.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class SecurityFilter {

  private SecurityIdentifier securityIdentifier = SecurityIdentifier.UNKNOWN;

  private SecurityId securityId;

  private Id addInDataId;

  /**
   * The value indicating whether this feature is Added or Removed.
   *
   * <p>Please note this property is
   * evaluated in the context of the SecurityFilter(s) available to the parent SecurityClearance.
   */
  @JsonProperty("isAdd")
  private boolean isAdd;
}
