package com.geotab.model.coordinate;

import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * A coordinate that is related to a DateTime.
 */
@Data
@NoArgsConstructor
public class TemporalCoordinate extends Coordinate {

  /**
   * The date and time of this coordinate.
   */
  private LocalDateTime dateTime;

  public TemporalCoordinate(double x, double y, LocalDateTime dateTime) {
    super(x, y);
    this.dateTime = dateTime;
  }
}
