/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.drawing;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class Color {

  public static final Color RED = new Color(255, 0, 0);
  public static final Color WHITE = new Color(255, 255, 255);
  public static final Color GREEN = new Color(0, 255, 0);
  public static final Color BLUE = new Color(0, 0, 255);
  public static final Color BLACK = new Color(0, 0, 0);
  public static final Color EMPTY = new Color(0, 0, 0);

  private int r;
  private int g;
  private int b;
  private int a;

  public Color(int r, int g, int b) {
    this(r, g, b, 255);
  }

  @Builder(builderMethodName = "colorBuilder")
  public Color(int r, int g, int b, int a) {
    this.r = r;
    this.g = g;
    this.b = b;
    this.a = a;
  }

  public int toArgb() {
    return ((a & 255) << 24) | ((r & 255) << 16) | ((g & 255) << 8) | (b & 255);
  }
}
