/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.drawing;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * A point with a float X and Y.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PointF {

  /**
   * An empty point.
   */
  public static final PointF EMPTY = new PointF(0F, 0F);

  /**
   * The X coordinate.
   */
  private Float x;

  /**
   * The Y coordinate.
   */
  private Float y;
}
