package com.geotab.model.entity.addins;

import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Add-Ins are used to extend the functionality provided by MyGeotab and Geotab Drive. An Add-In is JavaScript, HTML
 * and CSS loaded into the MyGeotab or Geotab Drive portal and resides directly inside the user interface. This allows
 * third-parties to create a seamless user experience and provide solutions that would otherwise require the user to
 * visit a different website altogether.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class AddIn extends Entity {
  /**
   * Gets or sets the {@link AddInConfiguration}.
   */
  private AddInConfiguration configuration;

  /**
   * Gets or sets the marketplace Add-In Url.
   */
  private String url;

  /**
   * Gets or sets the error message if there was an issue with Add-In.
   */
  private String errorMessage;

  /**
   * Gets or sets whether the Add-In is inactive.
   */
  private Boolean isInactive;

  /**
   * Gets or sets the timestamp when Add-In is changed.
   */
  private LocalDateTime updateTime;

  /**
   * Gets or sets the Add-In solution Id.
   */
  private String solutionId;

  /**
   * Initializes a new instance of the {@link AddIn} class.
   *
   * @param id The identifier.
   * @param configuration The configuration.
   * @param url The url.
   * @param isInactive Whether the Add-In is inactive.
   * @param updateTime The timestamp when Add-In is changed.
   * @param solutionId The solution id of the AddIn.
   */
  public AddIn(Id id, AddInConfiguration configuration, String url, Boolean isInactive, LocalDateTime updateTime, String solutionId) {
    this.setId(id);
    this.configuration = configuration;
    this.url = url;
    this.isInactive = isInactive;
    this.updateTime = updateTime;
    this.solutionId = solutionId;
  }
}
