package com.geotab.model.entity.addins;

import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.group.Group;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A class that holds data stored by an add-in.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class AddInData extends Entity {
  /**
   * Gets or sets the add-in identifier.
   */
  private Id addInId;

  /**
   * Gets or sets the Details string as a serialized JSON object.
   */
  private String details;

  /**
   * Gets or sets the list of {@link Group}(s) the {@link AddInData} belongs to.
   */
  private List<Group> groups;
}
