package com.geotab.model.entity.addins;

import com.geotab.model.entity.Entity;
import com.geotab.model.entity.device.Device;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Link between an {@link AddIn} and a {@link Device}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class AddInDeviceLink extends Entity {
  /**
   * Gets or sets the {@link AddIn}.
   */
  public AddIn addIn;

  /**
   * Gets or sets the {@link Device}.
   */
  public Device device;

  /**
   * Gets or sets the timestamp when Add-in Device Link changed.
   */
  public LocalDateTime dateTime;

  /**
   * Validates if the required properties are set.
   *
   * @throws NullPointerException Exception returned when a property is missing its value.
   */
  public void validate() {
    if (this.addIn.getId() == null) {
      throw new NullPointerException("addIn.id can't be null");
    }
    if (this.device.getId() == null) {
      throw new NullPointerException("device.id can't be null");
    }
    if (this.dateTime == null) {
      throw new NullPointerException("dateTime can't be null");
    }
  }
}
