package com.geotab.model.entity.addins;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Represents the Add-In Button item.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Button implements AddInItem {
  /**
   * Gets or sets the built-in page to place the button on.
   */
  private String page;

  /**
   * Gets or sets a URL to a JavaScript file which is executed when the button is clicked.
   */
  private String click;

  /**
   * Gets or Sets {@link ItemName}.
   */
  private ItemName buttonName;
  
  /**
   * Gets or Sets the button name.
   */
  private String buttonNameString;

  /**
   * Gets or Sets a URL to the svg image for placing it in the button label.
   */
  private String svgIcon;
  
  /**
   * Gets or Sets a URL to the image for placing it in the button label.
   */
  private String icon;
}
