package com.geotab.model.entity.addins;

import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A custom security ID which can be used to control access to custom Add-Ins.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class CustomSecurityId {
  /**
   * Gets or sets the name of the custom security ID.
   */
  private String name;

  /**
   * Gets or sets the translations of the custom security ID.
   */
  private List<CustomSecurityIdTranslation> translations;
}
