package com.geotab.model.entity.addins;

import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * An object containing key value pairs for the text that appears on the item.
 * The key is the language and the value is the text, for example: {"EN", "New item"}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class ItemName {
  /**
   * Gets or sets the language translations for the Item name.
   */
  public Map<String, String> translations;
}
