package com.geotab.model.entity.addins;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Represents the Map Add-in item.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Map implements AddInItem {
  /**
   * Gets or sets the page the Map Add-in will reside within.
   * @implNote This could be “map” (The Map page) or “tripsHistory” (the Trips History page). The default value is “map”.
   */
  private String page;

  /**
   * Gets or sets the heading displayed at the top of the panel when there are multiple Map Add-ins installed and title is listed in multiple
   * languages.
   * @implNote If a "title" is not provided, the Add-in defaults to the "name" parameter.
   */
  private ItemName title;

  /**
   * Gets or sets the heading displayed at the top of the panel when there are multiple Map Add-ins installed.
   * @implNote If a "title" is not provided, the Add-in defaults to the "name" parameter.
   */
  private String titleString;

  /**
   * Gets or sets a value indicating whether the add-in will be displayed in the right-side panel.
   * @implNote The default value is false.
   */
  private Boolean noView = false;

  /**
   * Gets or sets the {@link MapScript}.
   */
  private MapScript mapScript;
}