package com.geotab.model.entity.addins;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@Data
@NoArgsConstructor
@SuperBuilder
public class MapScript {
  /**
   * Gets or sets the JavaScript file reference for the Add-in.
   * @implNote This can be an externally hosted file or uploaded into MyGeotab by dragging and dropping it into the Configuration file window.
   */
  private String src;

  /**
   * Gets or sets the JavaScript code for the Add-in.
   * @implNote This can be an externally hosted file or uploaded into MyGeotab by dragging and dropping it into the Configuration file window.
   */
  private String script;

  /**
   * Gets or sets the CSS file reference for this Add-In.
   * @implNote This can be externally hosted or uploaded to MyGeotab.
   */
  private String style;

  /**
   * Gets or sets the HTML file reference for this Add-In.
   * @implNote This option can be used instead of src and style. Links to CSS and JavaScript files can be made within this HTML file.
   *     All content within the body tags will be added to the Map Add-in UI.
   */
  private String url;
}
