package com.geotab.model.entity.addins;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Represents the Add-In Menu item.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Menu implements AddInItem {
  /**
   * Gets or Sets the URL to the HTML page to load when clicking on this menu item.
   */
  private String url;

  /**
   * Gets or Sets where in the menu hierarchy this menu item should reside.
   */
  private String path;

  /**
   * Gets or Sets where in the new navigation bar this menu item should reside.
   */
  private String category;

  /**
   * Gets or Sets {@link ItemName}.
   */
  private ItemName menuName;

  /**
   * Gets or Sets the menu name.
   */
  private String menuNameString;

  /**
   * Gets or Sets a URL to the svg image that is placed in front of the menu item.
   */
  private String svgIcon;

  /**
   * Gets or Sets a URL to the image for placing it in the Menu label.
   */
  private String icon;

  /**
   * Gets or Sets a unique identifier for this menu.
   */
  private String menuId;
}
