/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.audit;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.EntityAsIdSerializer;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Entry of events, operations and issues for tracking purposes. Entries can be added and read but cannot be edited.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Audit extends NameEntityWithVersion {

  /**
   * The {@link User} the audit is in reference to.
   */
  @JsonSerialize(using = EntityAsIdSerializer.class)
  private User user;

  /**
   * The date and time the audit was logged.
   */
  private LocalDateTime dateTime;

  /**
   * Free text field where any user information can be stored and referenced for this entity.
   */
  private String comment;

  /**
   * The name of the user associated with the audit entry.
   */
  private String userName;
}
