/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.certificate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.Entity;
import com.geotab.model.serialization.X509CertificateDeserializer;
import com.geotab.model.serialization.X509CertificateSerializer;
import java.security.cert.X509Certificate;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * An object representing a X509Certificate used to check if a message came from the correct external source.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Certificate extends Entity {

  /**
   * The issuer of the certificate.
   */
  private String issuer;

  /**
   * The public key of the certificate.
   */
  @JsonSerialize(using = X509CertificateSerializer.class)
  @JsonDeserialize(using = X509CertificateDeserializer.class)
  private X509Certificate key;

  /**
   * The url to go to when as user with this certificate logs off.
   */
  private String logOffUrl;

  /**
   * The url to go to when as user with this certificate logs in.
   */
  private String logInUrl;

  /**
   * Value indicating whether certificate is a root certificate that is used for validating all client certificate.
   */
  @JsonProperty("isRoot")
  private boolean isRoot;
}
