package com.geotab.model.entity.charging;

import com.geotab.model.Id;
import com.geotab.model.coordinate.Coordinate;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.trip.Trip;
import java.time.Duration;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * An event representing charging a vehicle {@link
 * com.geotab.model.entity.charging.ChargeEvent}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class ChargeEvent extends EntityWithVersion {
  /**
   * The id.
   */
  private Id id;

  /**
   * The time the charge event started (UTC).
   */
  private LocalDateTime startTime;

  /**
   * How long the vehicle was charging (seconds).
   */
  private Duration duration;

  /**
   * The {@link Coordinate} (SimpleCoordinate) of where the charge event occurred.
   */
  private Coordinate location;

  /**
   * The charging type provided by the external power source.
   */
  private ChargeType chargeType;

  /**
   * The {@link Device} that created the ChargeEvent.
   */
  private Device device;

  /**
   * Value indicating whether the charge event used estimated charge values.
   */
  private Boolean chargeIsEstimated;

  /**
   * The time of the Trip Stop from the {@link Trip} this charge event occurred in.
   */
  private LocalDateTime tripStop;

  /**
   * The maximum AC Voltage over the charge event.
   */
  private Double maxAcVoltage;

  /**
   * The starting state of charge for this charge event.
   */
  private Double startStateOfCharge;

  /**
   * The ending state of charge for this charge event.
   */
  private Double endStateOfCharge;

  /**
   * The energy consumed during the charge event (KwH).
   */
  private Double energyConsumedKwh;

  /**
   * The peak power used during the charge event.
   */
  private Double peakPowerKw;

  /**
   * The amount of energy drawn from the battery since the last charge event.
   */
  private Double energyUsedSinceLastChargeKwh;

  /**
   * The odometer in km at charge start event.
   */
  private Double chargingStartedOdometerKm;

  /**
   * The total amount of energy in measured on board during charging.
   */
  private Double measuredOnBoardChargerEnergyInKwh;

  /**
   * The total amount of energy out measured on board during charging.
   */
  private Double measuredOnBoardChargerEnergyOutKwh;

  /**
   * The amount of energy in measured during charging.
   */
  private Double measuredBatteryEnergyInKwh;

  /**
   * The amount of energy out measured during charging.
   */
  private Double measuredBatteryEnergyOutKwh;

  public ChargeEvent(String id) {
    setId(new Id(id));
  }
}
